/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.decompile.OpenedURLClassLoader;
import io.wispforest.gadget.decompile.QuiltflowerHandler;
import io.wispforest.gadget.decompile.QuiltflowerVersions;
import io.wispforest.gadget.util.ProgressToast;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import org.apache.commons.io.IOUtils;

public final class QuiltflowerManager {
    private static final Path DLC_DIRECTORY = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("dlc");
    private static SoftReference<OpenedURLClassLoader> CLASSLOADER = null;

    private QuiltflowerManager() {
    }

    public static boolean isInstalled() {
        return Files.isRegularFile(QuiltflowerManager.installedPath(), new LinkOption[0]);
    }

    public static Path installedPath() {
        return DLC_DIRECTORY.resolve("quiltflower-" + QuiltflowerVersions.effectiveVersion() + ".jar");
    }

    public static CompletableFuture<Void> ensureInstalled(ProgressToast toast) {
        if (QuiltflowerManager.isInstalled()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            toast.step((class_2561)class_2561.method_43471((String)"text.gadget.progress.downloading_quiltflower"));
            try {
                if (!Files.isDirectory(DLC_DIRECTORY, new LinkOption[0])) {
                    Files.createDirectories(DLC_DIRECTORY, new FileAttribute[0]);
                }
                String v = QuiltflowerVersions.effectiveVersion();
                String quiltflowerUrl = "https://maven.quiltmc.org/repository/release/org/quiltmc/quiltflower/" + v + "/quiltflower-" + v + ".jar";
                try (InputStream is = toast.loadWithProgress(new URL(quiltflowerUrl));
                     OutputStream os = Files.newOutputStream(QuiltflowerManager.installedPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static QuiltflowerHandler loadHandler(ProgressToast toast, Consumer<class_2561> logConsumer) {
        OpenedURLClassLoader cl;
        OpenedURLClassLoader openedURLClassLoader = cl = CLASSLOADER == null ? null : CLASSLOADER.get();
        if (cl == null) {
            try {
                String classUrl = Gadget.class.getClassLoader().getResource("io/wispforest/gadget/Gadget.class").toString();
                URL dirUrl = new URL(classUrl.replace("io/wispforest/gadget/Gadget.class", ""));
                cl = new OpenedURLClassLoader(new URL[]{QuiltflowerManager.installedPath().toUri().toURL(), dirUrl}, Gadget.class.getClassLoader(), "io.wispforest.gadget.decompile.handle.");
                CLASSLOADER = new SoftReference<OpenedURLClassLoader>(cl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> implClass = cl.loadClass("io.wispforest.gadget.decompile.handle.QuiltflowerHandlerImpl");
            return (QuiltflowerHandler)implClass.getConstructors()[0].newInstance(toast, logConsumer);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

