/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile.handle;

import io.wispforest.gadget.decompile.handle.GadgetOutputSink;
import io.wispforest.gadget.decompile.handle.GadgetResultSaver;
import io.wispforest.gadget.decompile.handle.QuiltflowerHandlerImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class ClassContextSource
implements IContextSource {
    private final QuiltflowerHandlerImpl handler;
    private final Class<?>[] classes;

    public ClassContextSource(QuiltflowerHandlerImpl handler, Class<?> klass) {
        this.handler = handler;
        this.classes = klass.getNestHost().getNestMembers();
    }

    public String getName() {
        return "Class";
    }

    public IContextSource.Entries getEntries() {
        ArrayList<IContextSource.Entry> klasses = new ArrayList<IContextSource.Entry>();
        for (Class<?> klass : this.classes) {
            klasses.add(IContextSource.Entry.parse((String)this.handler.mapClass(klass.getName().replace('.', '/'))));
        }
        return new IContextSource.Entries(klasses, List.of(), List.of());
    }

    public InputStream getInputStream(String resource) {
        byte[] bytes = this.handler.getClassBytes(this.handler.mapClass(resource.replace(".class", "")));
        return new ByteArrayInputStream(bytes);
    }

    public IContextSource.IOutputSink createOutputSink(IResultSaver saver) {
        return new GadgetOutputSink((GadgetResultSaver)saver);
    }
}

