/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile.handle;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.decompile.KnotUtil;
import io.wispforest.gadget.decompile.OpenedURLClassLoader;
import io.wispforest.gadget.decompile.QuiltflowerHandler;
import io.wispforest.gadget.decompile.handle.ClassContextSource;
import io.wispforest.gadget.decompile.handle.EverythingContextSource;
import io.wispforest.gadget.decompile.handle.GadgetFernflowerLogger;
import io.wispforest.gadget.decompile.handle.GadgetResultSaver;
import io.wispforest.gadget.decompile.remap.GadgetRemapper;
import io.wispforest.gadget.decompile.remap.RemapperStore;
import io.wispforest.gadget.mappings.LocalMappings;
import io.wispforest.gadget.mappings.MappingsManager;
import io.wispforest.gadget.util.ProgressToast;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsRenamer;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraft.class_2561;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class QuiltflowerHandlerImpl
implements QuiltflowerHandler {
    private final MemoryMappingTree mappings;
    private final RemapperStore remapperStore;
    private final Map<String, byte[]> unmappedClassBytecodeStash = new HashMap<String, byte[]>();
    private final Map<String, byte[]> classBytecodeStash = new HashMap<String, byte[]>();
    private final List<String> allUnmappedClasses;
    final Consumer<class_2561> logConsumer;

    public QuiltflowerHandlerImpl(ProgressToast toast, Consumer<class_2561> logConsumer) {
        this.logConsumer = logConsumer;
        this.allUnmappedClasses = new ArrayList<String>();
        for (Class klass : KnotUtil.INSTRUMENTATION.getInitiatedClasses(Gadget.class.getClassLoader())) {
            if (klass.isHidden() || klass.isArray()) continue;
            this.allUnmappedClasses.add(klass.getName().replace('.', '/'));
        }
        toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.loading_mappings"));
        this.mappings = new MemoryMappingTree(true);
        try {
            MappingsManager.runtimeMappings().accept((MappingVisitor)this.mappings);
            this.mappings.visitNamespaces("intermediary", List.of("source"));
            int srcId = this.mappings.getNamespaceId("source");
            for (MappingTree.ClassMapping c : this.mappings.getClasses()) {
                String cName = c.getName("named");
                if (cName == null) {
                    cName = c.getName("intermediary");
                }
                c.setDstName(cName, srcId);
                for (MappingTree.FieldMapping f : c.getFields()) {
                    String fName = f.getName("named");
                    if (fName == null) {
                        fName = f.getName("intermediary");
                    }
                    f.setDstName(fName, srcId);
                }
                for (MappingTree.MethodMapping m : c.getMethods()) {
                    String mName = m.getName("named");
                    if (mName == null) {
                        mName = m.getName("intermediary");
                    }
                    m.setDstName(mName, srcId);
                }
            }
            MappingsManager.displayMappings().load((MappingVisitor)new MappingNsRenamer((MappingVisitor)this.mappings, Map.of("named", "target")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remapperStore = new RemapperStore(this::getUnmappedClassBytes, logConsumer, (MappingTree)this.mappings, "source", "target");
    }

    @Override
    public String mapClass(String name) {
        MappingTree.ClassMapping c = this.mappings.getClass(name, this.mappings.getNamespaceId("source"));
        if (c == null) {
            return name;
        }
        String mapped = c.getName("target");
        return mapped == null ? name : mapped;
    }

    @Override
    public String unmapClass(String name) {
        return LocalMappings.INSTANCE.mapClass(MappingsManager.displayMappings().unmapClass(name));
    }

    public byte[] getUnmappedClassBytes(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        return this.unmappedClassBytecodeStash.computeIfAbsent(path.replace('/', '.'), name2 -> KnotUtil.getPostMixinClassByteArray(name2, true));
    }

    public List<String> allUnmappedClasses() {
        return this.allUnmappedClasses;
    }

    @Override
    public byte[] getClassBytes(String name) {
        return this.classBytecodeStash.computeIfAbsent(name, unused -> {
            String remapped = this.unmapClass(name);
            byte[] bytes = this.getUnmappedClassBytes(remapped);
            if (name.startsWith("java/")) {
                return bytes;
            }
            ClassReader reader = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(0);
            try {
                GadgetRemapper remapper = this.remapperStore.createRemapper();
                reader.accept((ClassVisitor)new ClassRemapper((ClassVisitor)cw, (Remapper)remapper), 0);
            }
            catch (Throwable cnfe) {
                throw new RuntimeException(cnfe);
            }
            return cw.toByteArray();
        });
    }

    @Override
    public String decompileClass(Class<?> klass) {
        GadgetResultSaver resultSaver = new GadgetResultSaver();
        Fernflower fernflower = new Fernflower((IResultSaver)resultSaver, Map.of("ind", "    "), (IFernflowerLogger)new GadgetFernflowerLogger(this));
        fernflower.addSource((IContextSource)new ClassContextSource(this, klass));
        if (Gadget.CONFIG.fullDecompilationContext()) {
            fernflower.addLibrary((IContextSource)new EverythingContextSource(this));
        }
        fernflower.decompileContext();
        fernflower.clearContext();
        return resultSaver.saved;
    }

    static {
        OpenedURLClassLoader cl = (OpenedURLClassLoader)QuiltflowerHandlerImpl.class.getClassLoader();
        if (cl == Gadget.class.getClassLoader()) {
            throw new UnsupportedOperationException("Quiltflower handler was loaded on Knot!");
        }
    }
}

