/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile.remap;

import io.wispforest.gadget.decompile.remap.MemberData;
import io.wispforest.gadget.decompile.remap.MemberType;
import java.util.List;

public record AnalyzedClass(String name, AnalyzedClass superclass, List<AnalyzedClass> interfaces, List<MemberData> declaredFields, List<MemberData> declaredMethods) {
    public List<MemberData> declaredMembers(MemberType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MemberType.METHOD -> this.declaredMethods;
            case MemberType.FIELD -> this.declaredFields;
        };
    }

    public MemberData member(MemberType type, String fName, String fDesc) {
        for (MemberData id : this.declaredMembers(type)) {
            if (!id.name().equals(fName) || !id.desc().equals(fDesc)) continue;
            return id;
        }
        return this.openMember(type, fName, fDesc);
    }

    public MemberData openMember(MemberType type, String fName, String fDesc) {
        MemberData member;
        for (MemberData id : this.declaredMembers(type)) {
            if (id.isClosed() || !id.name().equals(fName) || !id.desc().equals(fDesc)) continue;
            return id;
        }
        if (this.superclass != null && (member = this.superclass.openMember(type, fName, fDesc)) != null) {
            return member;
        }
        for (AnalyzedClass iface : this.interfaces) {
            MemberData member2 = iface.openMember(type, fName, fDesc);
            if (member2 == null) continue;
            return member2;
        }
        return null;
    }
}

