/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile.remap;

import io.wispforest.gadget.decompile.remap.AnalyzedClass;
import io.wispforest.gadget.decompile.remap.MemberData;
import io.wispforest.gadget.decompile.remap.MemberType;
import io.wispforest.gadget.decompile.remap.RemapperStore;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassAnalyzer
extends ClassVisitor {
    private String name;
    private AnalyzedClass superclass;
    private final List<AnalyzedClass> interfaces = new ArrayList<AnalyzedClass>();
    private final List<MemberData> declaredFields = new ArrayList<MemberData>();
    private final List<MemberData> declaredMethods = new ArrayList<MemberData>();
    private final RemapperStore store;

    public ClassAnalyzer(RemapperStore store) {
        super(589824);
        this.store = store;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        if (superName != null) {
            this.superclass = this.store.getClass(superName);
        }
        for (String iface : interfaces) {
            AnalyzedClass c = this.store.getClass(iface);
            if (c == null) continue;
            this.interfaces.add(c);
        }
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        boolean isClosed = (access & 5) == 0 || (access & 8) != 0;
        this.declaredFields.add(new MemberData(MemberType.FIELD, this.name, name, descriptor, isClosed));
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        boolean isPrivate;
        boolean bl = isPrivate = (access & 5) == 0;
        if (!isPrivate) {
            if (this.superclass != null && this.superclass.openMember(MemberType.METHOD, name, descriptor) != null) {
                return null;
            }
            for (AnalyzedClass iface : this.interfaces) {
                if (iface.openMember(MemberType.METHOD, name, descriptor) == null) continue;
                return null;
            }
        }
        this.declaredMethods.add(new MemberData(MemberType.METHOD, this.name, name, descriptor, isPrivate));
        return null;
    }

    public AnalyzedClass build() {
        return new AnalyzedClass(this.name, this.superclass, this.interfaces, this.declaredFields, this.declaredMethods);
    }
}

