/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile.remap;

import io.wispforest.gadget.decompile.remap.AnalyzedClass;
import io.wispforest.gadget.decompile.remap.MemberData;
import io.wispforest.gadget.decompile.remap.MemberType;
import io.wispforest.gadget.decompile.remap.RemapperStore;
import io.wispforest.gadget.mappings.MappingUtils;
import net.fabricmc.mappingio.tree.MappingTree;
import org.objectweb.asm.commons.Remapper;

public class GadgetRemapper
extends Remapper {
    private final RemapperStore store;
    private final MappingTree tree;
    private final int srcId;
    private final int dstId;

    public GadgetRemapper(RemapperStore store, MappingTree tree, int srcId, int dstId) {
        this.store = store;
        this.tree = tree;
        this.srcId = srcId;
        this.dstId = dstId;
    }

    public String map(String internalName) {
        MappingTree.ClassMapping c = this.tree.getClass(internalName, this.srcId);
        if (c == null) {
            return internalName;
        }
        return c.getName(this.dstId);
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        AnalyzedClass c = this.store.getClass(owner);
        if (c == null) {
            return name;
        }
        MemberData f = c.member(MemberType.FIELD, name, descriptor);
        if (f == null) {
            return name;
        }
        return MappingUtils.fieldTargetName(this.tree, this.srcId, this.dstId, f.owner(), f.name(), f.desc(), true);
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        AnalyzedClass c = this.store.getClass(owner);
        if (c == null) {
            return name;
        }
        MemberData m = c.member(MemberType.METHOD, name, descriptor);
        if (m == null) {
            return name;
        }
        return MappingUtils.methodTargetName(this.tree, this.srcId, this.dstId, m.owner(), m.name(), m.desc(), true);
    }

    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return this.mapFieldName(owner, name, descriptor);
    }
}

