/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.decompile.remap;

import io.wispforest.gadget.decompile.remap.AnalyzedClass;
import io.wispforest.gadget.decompile.remap.ClassAnalyzer;
import io.wispforest.gadget.decompile.remap.GadgetRemapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.mappingio.tree.MappingTree;
import net.minecraft.class_2561;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class RemapperStore {
    private final Map<String, AnalyzedClass> analyzedClasses = new HashMap<String, AnalyzedClass>();
    private final Function<String, byte[]> bytecodeProvider;
    private final Consumer<class_2561> logConsumer;
    final MappingTree tree;
    final int srcId;
    final int dstId;

    public RemapperStore(Function<String, byte[]> bytecodeProvider, Consumer<class_2561> logConsumer, MappingTree tree, String src, String dst) {
        this.bytecodeProvider = bytecodeProvider;
        this.logConsumer = logConsumer;
        this.tree = tree;
        this.srcId = tree.getNamespaceId(src);
        this.dstId = tree.getNamespaceId(dst);
    }

    public GadgetRemapper createRemapper() {
        return new GadgetRemapper(this, this.tree, this.srcId, this.dstId);
    }

    public AnalyzedClass getClass(String internalName) {
        AnalyzedClass klass = this.analyzedClasses.get(internalName);
        if (klass == null) {
            klass = this.analyze(internalName);
            this.analyzedClasses.put(internalName, klass);
        }
        return klass;
    }

    private AnalyzedClass analyze(String name) {
        if (name.startsWith("[")) {
            return new AnalyzedClass(name, this.getClass("java/lang/Object"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        this.logConsumer.accept((class_2561)class_2561.method_43469((String)"text.gadget.log.loading_class", (Object[])new Object[]{name}));
        byte[] bytes = this.bytecodeProvider.apply(name);
        if (bytes == null) {
            return null;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassAnalyzer analyzer = new ClassAnalyzer(this);
        reader.accept((ClassVisitor)analyzer, 0);
        return analyzer.build();
    }
}

