/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.desc;

import io.netty.buffer.ByteBuf;
import io.wispforest.gadget.desc.BytesFieldObject;
import io.wispforest.gadget.desc.ComplexFieldObject;
import io.wispforest.gadget.desc.ErrorFieldObject;
import io.wispforest.gadget.desc.FieldObject;
import io.wispforest.gadget.desc.NbtCompoundFieldObject;
import io.wispforest.gadget.desc.PrimitiveFieldObject;
import io.wispforest.gadget.desc.edit.PrimitiveEditData;
import io.wispforest.gadget.mappings.MappingsManager;
import io.wispforest.gadget.network.FieldData;
import io.wispforest.gadget.path.FieldPathStep;
import io.wispforest.gadget.path.IndexPathStep;
import io.wispforest.gadget.path.MapPathStep;
import io.wispforest.gadget.path.MapPathStepType;
import io.wispforest.gadget.path.PathStep;
import io.wispforest.gadget.util.InfallibleClosable;
import io.wispforest.gadget.util.NetworkUtil;
import io.wispforest.gadget.util.PrettyPrinters;
import io.wispforest.gadget.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.auoeke.reflect.Accessor;
import net.auoeke.reflect.Fields;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public final class FieldObjects {
    private FieldObjects() {
    }

    public static Map<PathStep, FieldData> getData(Object o, Set<Object> pathObjs, int from, int limit) {
        MutableInt total = new MutableInt();
        LinkedHashMap<PathStep, FieldData> collected = new LinkedHashMap<PathStep, FieldData>();
        FieldObjects.collectAllData(o, pathObjs, (step, data) -> {
            int i = total.getAndIncrement();
            if (limit >= 0 && i >= from + limit) {
                return true;
            }
            if (i >= from) {
                collected.put((PathStep)step, (FieldData)data);
            }
            return false;
        });
        return collected;
    }

    public static void collectAllData(Object o, Set<Object> pathObjs, BiPredicate<PathStep, FieldData> receiver) {
        FieldObject obj;
        Map map;
        boolean isFinal;
        if (o == null) {
            return;
        }
        if (o instanceof Iterable) {
            Iterable iter = (Iterable)o;
            int i = 0;
            isFinal = ReflectionUtil.guessImmutability(iter);
            try {
                for (Object sub : iter) {
                    int n;
                    FieldObject obj2 = FieldObjects.fromObject(sub, pathObjs);
                    if (!receiver.test(new IndexPathStep(n = i++), new FieldData(obj2, false, isFinal))) continue;
                    return;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (o instanceof Map && !(map = (Map)o).isEmpty()) {
            Object oneKey = map.keySet().iterator().next();
            isFinal = ReflectionUtil.guessImmutability(map);
            MapPathStepType type = MapPathStepType.getFor(oneKey.getClass());
            if (type != null) {
                for (Map.Entry entry : map.entrySet()) {
                    FieldObject obj3;
                    MapPathStep path = new MapPathStep(type, type.toNetwork(entry.getKey()));
                    if (!receiver.test(path, new FieldData(obj3 = FieldObjects.fromObject(entry.getValue(), pathObjs), false, isFinal))) continue;
                    return;
                }
            } else {
                int i = 0;
                for (Map.Entry sub : map.entrySet()) {
                    int idx;
                    IndexPathStep path;
                    FieldObject obj4 = FieldObjects.fromObject(sub, pathObjs);
                    if (!receiver.test(path = new IndexPathStep(idx = i++), new FieldData(obj4, false, isFinal))) continue;
                    return;
                }
            }
        }
        if (o.getClass().isArray()) {
            int size = Array.getLength(o);
            for (int i = 0; i < size; ++i) {
                IndexPathStep path = new IndexPathStep(i);
                obj = FieldObjects.fromObject(Array.get(o, i), pathObjs);
                if (!receiver.test(path, new FieldData(obj, false, false))) continue;
                return;
            }
            return;
        }
        for (Field field : Fields.allInstance(o.getClass()).filter(x -> !x.isSynthetic())::iterator) {
            boolean isMixin;
            FieldPathStep path = FieldPathStep.forField(field);
            try {
                obj = FieldObjects.fromObject(Accessor.get((Object)o, (Field)field), pathObjs);
            }
            catch (Exception e) {
                obj = ErrorFieldObject.fromException(e);
            }
            if (!receiver.test(path, new FieldData(obj, isMixin = field.getAnnotation(MixinMerged.class) != null, false))) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldObject fromObject(Object o, Set<Object> pathObjs) {
        String tag;
        if (o instanceof class_2487) {
            class_2487 compound = (class_2487)o;
            return new NbtCompoundFieldObject(compound);
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return new BytesFieldObject(MappingsManager.unmapClass(o.getClass()), bytes);
        }
        if (o instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)o;
            int position = byteBuffer.position();
            int limit = byteBuffer.limit();
            try {
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                BytesFieldObject bytesFieldObject = new BytesFieldObject(MappingsManager.unmapClass(o.getClass()), bytes);
                return bytesFieldObject;
            }
            finally {
                byteBuffer.position(position);
                byteBuffer.limit(limit);
            }
        }
        if (o instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)o;
            try (InfallibleClosable ignored = NetworkUtil.resetIndexes(buf);){
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                BytesFieldObject bytesFieldObject = new BytesFieldObject(MappingsManager.unmapClass(o.getClass()), bytes);
                return bytesFieldObject;
            }
        }
        String pretty = PrettyPrinters.tryPrint(o);
        if (pretty != null) {
            return new PrimitiveFieldObject(pretty, Optional.ofNullable(PrimitiveEditData.forObject(o)));
        }
        if (o instanceof class_1799) {
            class_1799 stack = (class_1799)o;
            tag = "{" + stack.method_7947() + " " + String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909())) + "}";
        } else {
            tag = o.getClass().isEnum() ? "#" + ((Enum)o).name() : "@" + Integer.toHexString(System.identityHashCode(o));
        }
        return new ComplexFieldObject(MappingsManager.unmapClass(o.getClass()), tag, pathObjs.contains(o));
    }
}

