/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.desc.edit;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.wispforest.endec.Endec;
import io.wispforest.gadget.desc.edit.PrimitiveEditType;
import io.wispforest.gadget.desc.edit.RegistryEditType;
import io.wispforest.gadget.desc.edit.SimpleEditType;
import io.wispforest.gadget.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class PrimitiveEditTypes {
    private static final BiMap<String, PrimitiveEditType<?>> REGISTRY = HashBiMap.create();
    private static final Map<Class<?>, PrimitiveEditType<?>> CLASS_TO_TYPE = new HashMap();
    static final Endec<PrimitiveEditType<?>> ENDEC = Endec.STRING.xmap(arg_0 -> REGISTRY.get(arg_0), arg_0 -> REGISTRY.inverse().get(arg_0));

    private PrimitiveEditTypes() {
    }

    public static <T> void register(String name, Class<T> klass, PrimitiveEditType<T> type) {
        REGISTRY.put((Object)name, type);
        CLASS_TO_TYPE.put(klass, type);
    }

    public static <T> void registerSimple(String name, Class<T> klass, Function<String, T> fromImpl, Function<T, String> toImpl) {
        PrimitiveEditTypes.register(name, klass, new SimpleEditType<T>(fromImpl, toImpl));
    }

    public static <T> void registerForRegistry(Class<T> klass, class_2378<T> registry) {
        PrimitiveEditTypes.register(registry.method_46765().method_29177().toString(), klass, new RegistryEditType<T>(registry));
    }

    public static <T> PrimitiveEditType<T> getFor(Class<T> klass) {
        return ReflectionUtil.findFor(klass, CLASS_TO_TYPE);
    }

    public static void init() {
        PrimitiveEditTypes.registerSimple("boolean", Boolean.class, Boolean::parseBoolean, Object::toString);
        PrimitiveEditTypes.registerSimple("int", Integer.class, Integer::parseInt, Object::toString);
        PrimitiveEditTypes.registerSimple("long", Long.class, Long::parseLong, Object::toString);
        PrimitiveEditTypes.registerSimple("float", Float.class, Float::parseFloat, Object::toString);
        PrimitiveEditTypes.registerSimple("double", Double.class, Double::parseDouble, Object::toString);
        PrimitiveEditTypes.registerSimple("string", String.class, x -> x, String::toString);
        PrimitiveEditTypes.registerSimple("identifier", class_2960.class, class_2960::method_60654, class_2960::toString);
        PrimitiveEditTypes.registerSimple("uuid", UUID.class, UUID::fromString, UUID::toString);
        PrimitiveEditTypes.registerForRegistry(class_2248.class, class_7923.field_41175);
        PrimitiveEditTypes.registerForRegistry(class_1792.class, class_7923.field_41178);
        PrimitiveEditTypes.registerForRegistry(class_1299.class, class_7923.field_41177);
        PrimitiveEditTypes.registerForRegistry(class_2591.class, class_7923.field_41181);
        PrimitiveEditTypes.registerForRegistry(class_1291.class, class_7923.field_41174);
    }
}

