/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.dump.read;

import io.wispforest.gadget.dump.fake.FakeGadgetPacket;
import io.wispforest.gadget.dump.fake.GadgetDynamicRegistriesPacket;
import io.wispforest.gadget.dump.read.DumpedPacket;
import io.wispforest.gadget.dump.write.PacketDumping;
import io.wispforest.gadget.util.NetworkUtil;
import io.wispforest.gadget.util.ProgressToast;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.zip.GZIPInputStream;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2378;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2899;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5912;
import net.minecraft.class_7923;
import net.minecraft.class_9095;
import net.minecraft.class_9097;
import net.minecraft.class_9099;
import net.minecraft.class_9103;
import net.minecraft.class_9127;
import net.minecraft.class_9129;
import net.minecraft.class_9157;
import net.minecraft.class_9173;
import org.jetbrains.annotations.Nullable;

public class PacketDumpDeserializer {
    private PacketDumpDeserializer() {
    }

    public static ReadPacketDump readFrom(ProgressToast toast, Path path) throws IOException {
        try (InputStream is = toast.loadWithProgress(path);){
            ReadPacketDump readPacketDump = PacketDumpDeserializer.readNew(is);
            return readPacketDump;
        }
    }

    public static ReadPacketDump readNew(InputStream is) throws IOException {
        try (BufferedInputStream dis = new BufferedInputStream(new GZIPInputStream(is));){
            byte[] magic = dis.readNBytes(11);
            if (!Arrays.equals(magic, "gadget:dump".getBytes(StandardCharsets.UTF_8))) {
                throw new IllegalStateException("Invalid gdump file!");
            }
            int version = PacketDumpDeserializer.readInt(dis, false).orElseThrow();
            if (version == 1) {
                ReadPacketDump readPacketDump = PacketDumpDeserializer.readV1(dis);
                return readPacketDump;
            }
            throw new IllegalStateException("Invalid gdump version " + version);
        }
    }

    private static ReadPacketDump readV1(InputStream is) {
        ArrayList<DumpedPacket> list = new ArrayList<DumpedPacket>();
        class_2540 buf = PacketByteBufs.create();
        Int2ObjectOpenHashMap loginQueryChannels = new Int2ObjectOpenHashMap();
        class_5455.class_6890 registries = class_5455.method_40302((class_2378)class_7923.field_41167);
        try {
            while (true) {
                FakeGadgetPacket fake;
                OptionalInt len;
                if ((len = PacketDumpDeserializer.readInt(is, true)).isEmpty()) {
                    return new ReadPacketDump(list, null);
                }
                buf.method_52988(0);
                buf.method_52990(0);
                buf.method_52983(is.readNBytes(len.getAsInt()));
                short flags = buf.readShort();
                boolean outbound = (flags & 1) != 0;
                class_2539 phase = switch (flags & 0xE) {
                    case 0 -> class_2539.field_20590;
                    case 4 -> class_2539.field_20592;
                    case 6 -> class_2539.field_20593;
                    case 14 -> class_2539.field_45671;
                    case 2 -> class_2539.field_20591;
                    default -> throw new IllegalStateException();
                };
                long sentAt = buf.readLong();
                int size = buf.readableBytes();
                class_9127<?> state = PacketDumpDeserializer.createState(phase, outbound ? class_2598.field_11941 : class_2598.field_11942, (class_5455)registries);
                class_2596<?> packet = PacketDumping.readPacket(buf, state);
                class_2960 channelId = NetworkUtil.getChannelOrNull(packet);
                if (packet instanceof class_2899) {
                    class_2899 req = (class_2899)packet;
                    loginQueryChannels.put(req.comp_1567(), (Object)req.comp_1568().comp_1571());
                } else if (packet instanceof class_2913) {
                    class_2913 res = (class_2913)packet;
                    channelId = (class_2960)loginQueryChannels.get(res.comp_1569());
                } else if (packet instanceof GadgetDynamicRegistriesPacket) {
                    GadgetDynamicRegistriesPacket dyn = (GadgetDynamicRegistriesPacket)packet;
                    class_9173 clientRegistries = new class_9173();
                    dyn.elements().forEach((arg_0, arg_1) -> ((class_9173)clientRegistries).method_56583(arg_0, arg_1));
                    clientRegistries.method_56586(dyn.tags());
                    registries = clientRegistries.method_56585(class_5912.field_49043, class_5455.method_40302((class_2378)class_7923.field_41167), false);
                }
                if (packet instanceof FakeGadgetPacket && (fake = (FakeGadgetPacket)packet).isVirtual()) continue;
                list.add(new DumpedPacket(outbound, state.comp_2234(), packet, channelId, sentAt, size));
            }
        }
        catch (IOException e) {
            return new ReadPacketDump(list, e);
        }
    }

    private static class_9127<?> createState(class_2539 phase, class_2598 side, class_5455 registries) {
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case class_2539.field_20590 -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_11941: {
                        yield class_9097.field_48231;
                    }
                    case field_11942: 
                }
                throw new IllegalStateException();
            }
            case class_2539.field_20592 -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_11941: {
                        yield class_9103.field_48263;
                    }
                    case field_11942: 
                }
                yield class_9103.field_48264;
            }
            case class_2539.field_20593 -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_11941: {
                        yield class_9099.field_48247;
                    }
                    case field_11942: 
                }
                yield class_9099.field_48248;
            }
            case class_2539.field_45671 -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_11941: {
                        yield class_9157.field_48698;
                    }
                    case field_11942: 
                }
                yield class_9157.field_48699;
            }
            case class_2539.field_20591 -> {
                switch (side) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_11941: {
                        yield class_9095.field_48172.method_68875(class_9129.method_56350((class_5455)registries), () -> true);
                    }
                    case field_11942: 
                }
                yield class_9095.field_48173.method_68874(class_9129.method_56350((class_5455)registries));
            }
        };
    }

    private static OptionalInt readInt(InputStream is, boolean gracefulEof) throws IOException {
        int ch1 = is.read();
        int ch2 = is.read();
        int ch3 = is.read();
        int ch4 = is.read();
        if (gracefulEof && ch1 < 0) {
            return OptionalInt.empty();
        }
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return OptionalInt.of((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4);
    }

    public record ReadPacketDump(List<DumpedPacket> packets, @Nullable IOException finalError) {
    }
}

