/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.dump.read;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.dump.SearchWord;
import io.wispforest.gadget.dump.fake.GadgetReadErrorPacket;
import io.wispforest.gadget.dump.fake.GadgetWriteErrorPacket;
import io.wispforest.gadget.dump.read.DumpReaderContext;
import io.wispforest.gadget.dump.read.DumpedPacket;
import io.wispforest.gadget.dump.read.PacketDumpDeserializer;
import io.wispforest.gadget.dump.read.SearchTextData;
import io.wispforest.gadget.dump.read.handler.PlainTextPacketDumper;
import io.wispforest.gadget.util.CancellationToken;
import io.wispforest.gadget.util.FormattedDumper;
import io.wispforest.gadget.util.ProgressToast;
import io.wispforest.gadget.util.ReflectionUtil;
import io.wispforest.gadget.util.ThrowableUtil;
import io.wispforest.gadget.util.TimeUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.class_1074;
import net.minecraft.class_2596;

public class PacketDumpReader {
    private final List<DumpedPacket> packets;
    private final long startTime;
    private final long endTime;
    private final IOException readError;

    public PacketDumpReader(Path path, ProgressToast toast) throws IOException {
        PacketDumpDeserializer.ReadPacketDump raw = PacketDumpDeserializer.readFrom(toast, path);
        this.packets = raw.packets();
        this.readError = raw.finalError();
        DumpReaderContext ctxFeature = new DumpReaderContext(this);
        for (DumpedPacket packet : this.packets) {
            packet.put(DumpReaderContext.KEY, ctxFeature);
        }
        if (this.readError != null) {
            Gadget.LOGGER.error("Encountered IO error while reading dump, results may be incomplete", (Throwable)raw.finalError());
        }
        if (this.packets.size() > 0) {
            this.startTime = this.packets.get(0).sentAt();
            this.endTime = this.packets.get(this.packets.size() - 1).sentAt();
        } else {
            this.endTime = 0L;
            this.startTime = 0L;
        }
    }

    public List<DumpedPacket> packets() {
        return this.packets;
    }

    public IOException readError() {
        return this.readError;
    }

    public List<DumpedPacket> collectFor(String searchText, long from, int max) {
        return this.collectFor(searchText, from, max, unused -> {}, CancellationToken.NONE);
    }

    public List<DumpedPacket> collectFor(String searchText, long from, int max, IntConsumer progressConsumer, CancellationToken token) {
        List<SearchWord> words = SearchWord.parseSearch(searchText);
        ArrayList<DumpedPacket> collected = new ArrayList<DumpedPacket>();
        token.throwIfCancelled();
        block0: for (DumpedPacket packet : this.packets) {
            if (packet.sentAt() < from) continue;
            if (packet.sentAt() > from && collected.size() > max) break;
            String relevantText = packet.get(SearchTextData.KEY).searchText();
            token.throwIfCancelled();
            for (SearchWord word : words) {
                if (word.matches(relevantText)) continue;
                continue block0;
            }
            collected.add(packet);
            progressConsumer.accept(collected.size());
            token.throwIfCancelled();
        }
        token.throwIfCancelled();
        return collected;
    }

    public void dumpPacketToText(DumpedPacket packet, FormattedDumper out, int indent) {
        Record error;
        StringBuilder sb = new StringBuilder();
        class_2596<?> class_25962 = packet.packet();
        if (class_25962 instanceof GadgetReadErrorPacket) {
            GadgetReadErrorPacket errorPacket = (GadgetReadErrorPacket)class_25962;
            sb.append(class_1074.method_4662((String)"text.gadget.packet_read_error", (Object[])new Object[]{errorPacket.packetId()}));
        } else {
            class_25962 = packet.packet();
            if (class_25962 instanceof GadgetWriteErrorPacket) {
                GadgetWriteErrorPacket errorPacket = (GadgetWriteErrorPacket)class_25962;
                sb.append(class_1074.method_4662((String)"text.gadget.packet_write_error", (Object[])new Object[]{errorPacket.packetId()}));
            } else {
                sb.append(ReflectionUtil.nameWithoutPackage(packet.packet().getClass()));
                if (packet.channelId() != null) {
                    sb.append(" ").append(packet.channelId());
                }
            }
        }
        if (this.startTime < this.endTime) {
            sb.append(" [");
            sb.append(TimeUtil.toHMS(packet.sentAt() - this.startTime));
            sb.append("]");
        }
        out.write(indent, sb.toString());
        class_2596<?> class_25963 = packet.packet();
        if (class_25963 instanceof GadgetReadErrorPacket) {
            error = (GadgetReadErrorPacket)class_25963;
            out.writeLines(indent + 1, ThrowableUtil.throwableToString(((GadgetReadErrorPacket)error).exception()));
        }
        if ((class_25963 = packet.packet()) instanceof GadgetWriteErrorPacket) {
            error = (GadgetWriteErrorPacket)class_25963;
            out.writeLines(indent + 1, ((GadgetWriteErrorPacket)error).exceptionText());
        }
        ((PlainTextPacketDumper)PlainTextPacketDumper.EVENT.invoker()).dumpAsPlainText(packet, out, indent + 1, throwable -> {
            out.write(indent + 1, "----ERROR----");
            out.writeLines(indent + 1, ThrowableUtil.throwableToString(throwable));
            out.write(indent + 1, "-------------");
        });
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }
}

