/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.dump.read;

import io.wispforest.gadget.dump.read.DumpedPacket;
import io.wispforest.gadget.dump.read.handler.PacketUnwrapper;
import io.wispforest.gadget.dump.read.unwrapped.UnwrappedPacket;
import io.wispforest.gadget.util.ContextData;
import io.wispforest.gadget.util.ErrorSink;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public class UnwrappedPacketData {
    public static final ContextData.Key<DumpedPacket, UnwrappedPacketData> KEY = new ContextData.Key<DumpedPacket, UnwrappedPacketData>(UnwrappedPacketData::new);
    private final DumpedPacket packet;
    private SoftReference<UnwrappedPacket> unwrapped;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public UnwrappedPacketData(DumpedPacket packet) {
        this.packet = packet;
    }

    public UnwrappedPacket unwrap() {
        if (this.unwrapped == null || this.unwrapped.get() == null) {
            this.errors.clear();
            this.unwrapped = new SoftReference<UnwrappedPacket>(((PacketUnwrapper)PacketUnwrapper.EVENT.invoker()).tryUnwrap(this.packet, this.errors::add));
        }
        return this.unwrapped.get();
    }

    public void copyErrors(ErrorSink errSink) {
        this.errors.forEach(errSink::accept);
    }

    public List<Throwable> errors() {
        return this.errors;
    }
}

