/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.dump.write;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.dump.write.PacketDumping;
import io.wispforest.gadget.util.InfallibleClosable;
import io.wispforest.gadget.util.NetworkUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPOutputStream;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_9127;
import org.jetbrains.annotations.Nullable;

public class PacketDumpWriter
implements AutoCloseable {
    public static final int VERSION = 1;
    @Nullable
    protected OutputStream output;
    @Nullable
    protected Thread onExitThread;
    protected final Path path;
    protected final boolean flushAfterWrite;

    public PacketDumpWriter(Path path) throws IOException {
        this(path, Gadget.CONFIG.dumpSafety().createExitHook(), Gadget.CONFIG.dumpSafety().flushAfterWrite());
    }

    public PacketDumpWriter(Path path, boolean createExitHook, boolean flushAfterWrite) throws IOException {
        this.path = path;
        this.output = new GZIPOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE), true);
        this.flushAfterWrite = flushAfterWrite;
        ByteBuf headerBuf = Unpooled.buffer((int)15);
        headerBuf.writeBytes("gadget:dump".getBytes(StandardCharsets.UTF_8));
        headerBuf.writeInt(1);
        headerBuf.getBytes(headerBuf.readerIndex(), this.output, headerBuf.readableBytes());
        if (createExitHook) {
            this.onExitThread = new Thread(this::onVmStop, "Exit hook thread for " + String.valueOf(this));
            Runtime.getRuntime().addShutdownHook(this.onExitThread);
        }
    }

    public Path path() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(class_2596<?> packet, class_9127<?> state) {
        if (this.output == null) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        short flags = 0;
        if (state.comp_2235() == class_2598.field_11941) {
            flags = (short)(flags | 1);
        }
        switch (state.comp_2234()) {
            case field_20590: {
                break;
            }
            case field_20592: {
                flags = (short)(flags | 4);
                break;
            }
            case field_20593: {
                flags = (short)(flags | 6);
                break;
            }
            case field_45671: {
                flags = (short)(flags | 0xE);
                break;
            }
            case field_20591: {
                flags = (short)(flags | 2);
            }
        }
        try (InfallibleClosable ignored = NetworkUtil.writeByteLength(buf);){
            buf.method_52998((int)flags);
            buf.method_52974(System.currentTimeMillis());
            PacketDumping.writePacket(buf, packet, state);
        }
        PacketDumpWriter packetDumpWriter = this;
        synchronized (packetDumpWriter) {
            OutputStream out = this.output;
            if (out == null) {
                return;
            }
            try {
                buf.method_52949(buf.readerIndex(), out, buf.readableBytes());
                if (this.flushAfterWrite) {
                    out.flush();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isClosed() {
        return this.output == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PacketDumpWriter packetDumpWriter = this;
        synchronized (packetDumpWriter) {
            OutputStream out = this.output;
            if (out == null) {
                return;
            }
            try {
                this.output.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void onVmStop() {
        try {
            if (this.output == null) {
                return;
            }
            this.output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't close packet dump on VM exit", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        PacketDumpWriter packetDumpWriter = this;
        synchronized (packetDumpWriter) {
            if (this.output == null) {
                return;
            }
            this.output.close();
            this.output = null;
            Runtime.getRuntime().removeShutdownHook(this.onExitThread);
            this.onExitThread = null;
        }
    }

    public String toString() {
        return "PacketDumpWriter[" + String.valueOf(this.path) + "]";
    }
}

