/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.dump.write;

import io.netty.buffer.ByteBuf;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.dump.fake.FakeGadgetPacket;
import io.wispforest.gadget.dump.fake.GadgetDynamicRegistriesPacket;
import io.wispforest.gadget.dump.fake.GadgetReadErrorPacket;
import io.wispforest.gadget.dump.fake.GadgetWriteErrorPacket;
import io.wispforest.gadget.util.SlicingPacketByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_9127;
import net.minecraft.class_9139;

public final class PacketDumping {
    private static final Int2ObjectMap<class_9139<? super class_2540, ? extends FakeGadgetPacket>> PACKETS = new Int2ObjectOpenHashMap();

    private PacketDumping() {
    }

    public static void register(int id, class_9139<? super class_2540, ? extends FakeGadgetPacket> codec) {
        if (PACKETS.put(id, codec) != null) {
            throw new IllegalStateException("Codec on " + id + " collides with another codec");
        }
    }

    public static void writePacket(class_2540 buf, class_2596<?> packet, class_9127<?> state) {
        int startWriteIdx = buf.writerIndex();
        int packetId = 0;
        try {
            if (packet instanceof FakeGadgetPacket) {
                FakeGadgetPacket fakePacket = (FakeGadgetPacket)packet;
                packetId = fakePacket.id();
                buf.method_10804(packetId);
                fakePacket.codec().encode((Object)buf, (Object)fakePacket);
                return;
            }
            state.comp_2236().encode((Object)new SlicingPacketByteBuf((ByteBuf)buf), packet);
        }
        catch (Exception e) {
            buf.method_52990(startWriteIdx);
            Gadget.LOGGER.error("Error while writing packet {}", packet, (Object)e);
            GadgetWriteErrorPacket writeError = GadgetWriteErrorPacket.fromThrowable(packetId, e);
            buf.method_10804(writeError.id());
            writeError.codec().encode((Object)buf, (Object)writeError);
        }
    }

    public static class_2596<?> readPacket(class_2540 buf, class_9127<?> state) {
        int startOfData = buf.readerIndex();
        int packetId = buf.method_10816();
        try {
            class_9139 fakeCodec = (class_9139)PACKETS.get(packetId);
            if (fakeCodec != null) {
                return ((FakeGadgetPacket)fakeCodec.decode((Object)buf)).unwrapVanilla();
            }
            buf.method_52988(startOfData);
            return (class_2596)state.comp_2236().decode((Object)buf);
        }
        catch (Exception e) {
            buf.method_52988(startOfData);
            return GadgetReadErrorPacket.from(buf, packetId, e);
        }
    }

    static {
        PacketDumping.register(-1, GadgetWriteErrorPacket.CODEC);
        PacketDumping.register(-3, GadgetDynamicRegistriesPacket.CODEC);
    }
}

