/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.field;

import com.google.gson.stream.JsonWriter;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.desc.BytesFieldObject;
import io.wispforest.gadget.desc.ComplexFieldObject;
import io.wispforest.gadget.desc.ErrorFieldObject;
import io.wispforest.gadget.desc.FieldObject;
import io.wispforest.gadget.desc.NbtCompoundFieldObject;
import io.wispforest.gadget.desc.PrimitiveFieldObject;
import io.wispforest.gadget.field.FieldDataNode;
import io.wispforest.gadget.field.FieldDataSource;
import io.wispforest.gadget.mappings.MappingsManager;
import io.wispforest.gadget.network.FieldData;
import io.wispforest.gadget.path.FieldPathStep;
import io.wispforest.gadget.path.ObjectPath;
import io.wispforest.gadget.path.PathStep;
import io.wispforest.gadget.util.FormattedDumper;
import java.io.IOException;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public abstract class FieldDataHolder<N extends FieldDataNode<N>> {
    protected final FieldDataSource source;
    protected final boolean shortenNames;
    protected N root = null;

    public FieldDataHolder(FieldDataSource source, boolean shortenNames) {
        this.source = source;
        this.shortenNames = shortenNames;
    }

    protected void init() {
        this.root = this.createNodeFrom(ObjectPath.EMPTY, this.source.rootData());
        ((FieldDataNode)this.root).initChildren(this.processMap(ObjectPath.EMPTY, this.source.initialRootFields()));
    }

    public FieldDataSource source() {
        return this.source;
    }

    public N root() {
        return this.root;
    }

    public N get(ObjectPath path) {
        Object current = this.root;
        for (PathStep step : path.steps()) {
            Map children = ((FieldDataNode)current).childrenOrNull();
            if (children == null) {
                return null;
            }
            current = (FieldDataNode)children.get(step);
            if (current != null) continue;
            return null;
        }
        return current;
    }

    public CompletableFuture<Void> dumpToText(FormattedDumper dumper, int indent, N startingAt, int depthLeft) {
        return ((FieldDataNode)startingAt).ensureChildren().thenCompose(children -> {
            CompletionStage<Object> runningTotal = CompletableFuture.completedFuture(null);
            for (Map.Entry entry : children.entrySet()) {
                runningTotal = runningTotal.thenCompose(ignored -> {
                    FieldObject patt0$temp;
                    StringBuilder head = new StringBuilder();
                    FieldDataNode data = (FieldDataNode)entry.getValue();
                    head.append(data.fieldObj().type().charAt(0));
                    head.append(" ");
                    head.append(((PathStep)entry.getKey()).toString());
                    if (data.isMixin()) {
                        head.append(" (mixin)");
                    }
                    if ((patt0$temp = data.fieldObj()) instanceof PrimitiveFieldObject) {
                        PrimitiveFieldObject pfo = (PrimitiveFieldObject)patt0$temp;
                        head.append(" = ").append(pfo.contents());
                    } else if (data.fieldObj() instanceof ErrorFieldObject) {
                        head.append(" error!");
                    } else {
                        FieldObject patt1$temp = data.fieldObj();
                        if (patt1$temp instanceof ComplexFieldObject) {
                            ComplexFieldObject cfo = (ComplexFieldObject)patt1$temp;
                            String text = cfo.text();
                            if (this.shortenNames) {
                                text = text.substring(text.lastIndexOf(46) + 1);
                            }
                            head.append(" ").append(text);
                        } else {
                            FieldObject patt2$temp = data.fieldObj();
                            if (patt2$temp instanceof NbtCompoundFieldObject) {
                                NbtCompoundFieldObject nfo = (NbtCompoundFieldObject)patt2$temp;
                                head.append(" ").append(nfo.data());
                            } else {
                                FieldObject patt3$temp = data.fieldObj();
                                if (patt3$temp instanceof BytesFieldObject) {
                                    BytesFieldObject bfo = (BytesFieldObject)patt3$temp;
                                    head.append(" ").append(bfo.text());
                                }
                            }
                        }
                    }
                    dumper.write(indent, head.toString());
                    FieldObject patt4$temp = data.fieldObj();
                    if (patt4$temp instanceof ErrorFieldObject) {
                        ErrorFieldObject efo = (ErrorFieldObject)patt4$temp;
                        dumper.writeLines(indent + 1, efo.fullExceptionText());
                    } else {
                        FieldObject patt5$temp = data.fieldObj();
                        if (patt5$temp instanceof BytesFieldObject) {
                            BytesFieldObject bfo = (BytesFieldObject)patt5$temp;
                            dumper.writeHexDump(indent + 1, bfo.data());
                        }
                    }
                    if (data.fieldObj() instanceof ComplexFieldObject && depthLeft > 0) {
                        return this.dumpToText(dumper, indent + 1, data, depthLeft - 1);
                    }
                    return CompletableFuture.completedFuture(null);
                });
            }
            return runningTotal;
        });
    }

    public CompletableFuture<Void> dumpToJson(JsonWriter writer, N startingAt, int depthLeft, Consumer<ObjectPath> dumpingConsumer) {
        dumpingConsumer.accept(((FieldDataNode)startingAt).path());
        return ((FieldDataNode)startingAt).ensureChildren().thenCompose(children -> {
            try {
                writer.beginObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            CompletionStage<Object> runningTotal = CompletableFuture.completedFuture(null);
            for (Map.Entry entry : children.entrySet()) {
                runningTotal = runningTotal.thenCompose(ignored -> {
                    try {
                        ComplexFieldObject cfo;
                        FieldDataNode data = (FieldDataNode)entry.getValue();
                        writer.name(((PathStep)entry.getKey()).toString());
                        writer.beginObject();
                        writer.name("type");
                        writer.value(data.fieldObj().type());
                        writer.name("is_mixin");
                        writer.value(data.isMixin());
                        FieldObject patt0$temp = data.fieldObj();
                        if (patt0$temp instanceof PrimitiveFieldObject) {
                            PrimitiveFieldObject pfo = (PrimitiveFieldObject)patt0$temp;
                            writer.name("value");
                            writer.value(pfo.contents());
                        } else {
                            FieldObject patt1$temp = data.fieldObj();
                            if (patt1$temp instanceof ErrorFieldObject) {
                                ErrorFieldObject efo = (ErrorFieldObject)patt1$temp;
                                writer.name("class");
                                writer.value(efo.exceptionClass());
                                writer.name("full");
                                writer.value(efo.fullExceptionText());
                            } else {
                                FieldObject patt2$temp = data.fieldObj();
                                if (patt2$temp instanceof ComplexFieldObject) {
                                    ComplexFieldObject cfo2 = (ComplexFieldObject)patt2$temp;
                                    writer.name("class");
                                    writer.value(MappingsManager.displayMappings().mapClass(cfo2.className()));
                                    writer.name("tag");
                                    writer.value(cfo2.tag());
                                } else {
                                    FieldObject patt3$temp = data.fieldObj();
                                    if (patt3$temp instanceof NbtCompoundFieldObject) {
                                        NbtCompoundFieldObject nfo = (NbtCompoundFieldObject)patt3$temp;
                                        writer.name("data");
                                        writer.value(nfo.data().toString());
                                    } else {
                                        FieldObject patt4$temp = data.fieldObj();
                                        if (patt4$temp instanceof BytesFieldObject) {
                                            BytesFieldObject bfo = (BytesFieldObject)patt4$temp;
                                            writer.name("buffer_class");
                                            writer.value(MappingsManager.displayMappings().mapField(bfo.bufferClass()));
                                            writer.name("bytes_len");
                                            writer.value((long)bfo.data().length);
                                            writer.name("bytes_b64");
                                            writer.value(Base64.getEncoder().encodeToString(bfo.data()));
                                        }
                                    }
                                }
                            }
                        }
                        FieldObject patt5$temp = data.fieldObj();
                        if (patt5$temp instanceof ComplexFieldObject && !(cfo = (ComplexFieldObject)patt5$temp).isRepeat() && depthLeft > 0) {
                            writer.name("fields");
                            return this.dumpToJson(writer, data, depthLeft - 1, dumpingConsumer).thenRun(() -> {
                                try {
                                    writer.endObject();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                        }
                        writer.endObject();
                        return CompletableFuture.completedFuture(null);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return runningTotal.thenRun(() -> {
                try {
                    writer.endObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        });
    }

    protected abstract N createNodeFrom(ObjectPath var1, FieldData var2);

    Map<PathStep, N> processMap(ObjectPath base, Map<PathStep, FieldData> originalChildren) {
        LinkedHashMap<PathStep, N> nodes = new LinkedHashMap<PathStep, N>();
        for (Map.Entry<PathStep, FieldData> entry : originalChildren.entrySet()) {
            PathStep pathStep = entry.getKey();
            if (pathStep instanceof FieldPathStep) {
                FieldPathStep field = (FieldPathStep)pathStep;
                if (Gadget.CONFIG.hiddenFields().contains(field.fieldId())) continue;
            }
            nodes.put(entry.getKey(), this.createNodeFrom(base.then(entry.getKey()), entry.getValue()));
        }
        return nodes;
    }

    CompletableFuture<Map<PathStep, N>> requestFields(ObjectPath path, int from, int limit) {
        return this.source.requestFieldsOf(path, from, limit).thenApply(children -> this.processMap(path, (Map<PathStep, FieldData>)children));
    }
}

