/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.field;

import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.desc.FieldObject;
import io.wispforest.gadget.field.FieldDataHolder;
import io.wispforest.gadget.network.FieldData;
import io.wispforest.gadget.path.FieldPathStep;
import io.wispforest.gadget.path.ObjectPath;
import io.wispforest.gadget.path.PathStep;
import io.wispforest.gadget.util.WeakObservableDispatcher;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class FieldDataNode<N extends FieldDataNode<N>> {
    private static final WeakObservableDispatcher<List<String>> HIDDEN_FIELDS = new WeakObservableDispatcher();
    private final FieldDataHolder<N> holder;
    private final ObjectPath path;
    @Nullable
    private Map<PathStep, N> children = null;
    private final FieldObject fieldObj;
    private final boolean isFinal;
    private final boolean isMixin;

    public FieldDataNode(FieldDataHolder<N> holder, ObjectPath path, FieldData data) {
        this.holder = holder;
        this.path = path;
        this.fieldObj = data.obj();
        this.isFinal = data.isFinal();
        this.isMixin = data.isMixin();
        HIDDEN_FIELDS.register(newList -> {
            FieldPathStep field;
            PathStep patt0$temp;
            if (path.steps().length > 0 && (patt0$temp = path.last()) instanceof FieldPathStep && newList.contains((field = (FieldPathStep)patt0$temp).fieldId())) {
                this.onRemoved();
                return true;
            }
            return false;
        });
    }

    public ObjectPath path() {
        return this.path;
    }

    public FieldObject fieldObj() {
        return this.fieldObj;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    @Nullable
    public Map<PathStep, N> childrenOrNull() {
        return this.children;
    }

    public CompletableFuture<Map<PathStep, N>> ensureChildren() {
        if (this.children != null) {
            return CompletableFuture.completedFuture(this.children);
        }
        return this.holder.requestFields(this.path, 0, -1).thenApply(children -> {
            this.children = children;
            return children;
        });
    }

    public void onRemoved() {
        if (this.children != null) {
            this.resetChildren();
        }
    }

    public void resetChildren() {
        if (this.children != null) {
            for (Map.Entry<PathStep, N> entry : this.children.entrySet()) {
                ((FieldDataNode)entry.getValue()).onRemoved();
            }
        }
        this.children = null;
    }

    void initChildren(Map<PathStep, N> newChildren) {
        this.children = newChildren;
    }

    static {
        Gadget.CONFIG.subscribeToHiddenFields(HIDDEN_FIELDS::handle);
    }
}

