/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import io.wispforest.gadget.util.ProgressToast;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;

public final class IntermediaryLoader {
    public static final String INTERMEDIARY_ENDPOINT = "https://maven.fabricmc.net/net/fabricmc/intermediary/" + class_155.method_16673().comp_4025() + "/intermediary-" + class_155.method_16673().comp_4025() + "-v2.jar";

    private IntermediaryLoader() {
    }

    public static void loadIntermediary(ProgressToast toast, MappingVisitor visitor) throws IOException {
        Path mappingsDir = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("mappings");
        Files.createDirectories(mappingsDir, new FileAttribute[0]);
        Path intermediaryPath = mappingsDir.resolve("intermediary-" + class_155.method_16673().comp_4025() + ".jar");
        if (!Files.exists(intermediaryPath, new LinkOption[0])) {
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_intermediary"));
            try (InputStream is = toast.loadWithProgress(new URL(INTERMEDIARY_ENDPOINT));){
                FileUtils.copyToFile((InputStream)is, (File)intermediaryPath.toFile());
            }
        }
        try (FileSystem fs = FileSystems.newFileSystem(intermediaryPath, (ClassLoader)null);
             BufferedReader br = Files.newBufferedReader(fs.getPath("mappings/mappings.tiny", new String[0]));){
            Tiny2FileReader.read((Reader)br, (MappingVisitor)visitor);
        }
    }
}

