/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import io.wispforest.gadget.mappings.MappingUtils;
import io.wispforest.gadget.mappings.Mappings;
import io.wispforest.gadget.util.ProgressToast;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraft.class_2561;

public abstract class LoadingMappings
implements Mappings {
    private volatile Map<String, String> intermediaryToFieldMap = Collections.emptyMap();
    private volatile Map<String, String> intermediaryToClassMap = Collections.emptyMap();
    private volatile Map<String, String> intermediaryFromClassMap = Collections.emptyMap();
    private volatile Map<String, String> fieldIdToIntermediaryMap = Collections.emptyMap();

    public LoadingMappings() {
        ProgressToast toast = ProgressToast.create((class_2561)class_2561.method_43471((String)"message.gadget.loading_mappings"));
        toast.follow(CompletableFuture.runAsync(() -> {
            MemoryMappingTree tree = new MemoryMappingTree();
            this.load(toast, (MappingVisitor)tree);
            HashMap<String, String> classMap = new HashMap<String, String>();
            HashMap<String, String> classUnmap = new HashMap<String, String>();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            for (MappingTree.ClassMapping def : tree.getClasses()) {
                String intermediary = def.getName("intermediary");
                String named = def.getName("named");
                if (intermediary != null && named != null) {
                    classMap.put(intermediary, named);
                    classUnmap.put(named, intermediary);
                }
                for (MappingTree.FieldMapping field : def.getFields()) {
                    fieldMap.put(field.getName("intermediary"), field.getName("named"));
                }
            }
            this.intermediaryToFieldMap = fieldMap;
            this.intermediaryToClassMap = classMap;
            this.intermediaryFromClassMap = classUnmap;
            this.fieldIdToIntermediaryMap = MappingUtils.createFieldIdUnmap((MappingTreeView)tree, "named");
        }), false);
    }

    protected abstract void load(ProgressToast var1, MappingVisitor var2);

    @Override
    public String mapClass(String src) {
        src = src.replace('.', '/');
        return this.intermediaryToClassMap.getOrDefault(src, src).replace('/', '.');
    }

    @Override
    public String mapField(String src) {
        return this.intermediaryToFieldMap.getOrDefault(src, src);
    }

    @Override
    public String unmapClass(String dst) {
        dst = dst.replace('.', '/');
        return this.intermediaryFromClassMap.getOrDefault(dst, dst).replace('/', '.');
    }

    @Override
    public String unmapFieldId(String dst) {
        return this.fieldIdToIntermediaryMap.getOrDefault(dst, dst);
    }

    @Override
    public void load(MappingVisitor visitor) {
        this.load(new ProgressToast.Dummy(), visitor);
    }
}

