/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.wispforest.gadget.mappings.MappingUtils;
import io.wispforest.gadget.mappings.Mappings;
import io.wispforest.gadget.mappings.MappingsManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTreeView;

public final class LocalMappings
implements Mappings {
    public static final LocalMappings INSTANCE = new LocalMappings();
    private final Supplier<BiMap<String, String>> intermediaryToClassMap = Suppliers.memoize(() -> {
        MappingTreeView mappings = MappingsManager.runtimeMappings();
        HashBiMap inverse = HashBiMap.create();
        for (MappingTreeView.ClassMappingView def : mappings.getClasses()) {
            String intermediary = def.getName("intermediary");
            String target = def.getName(MappingsManager.runtimeNamespace());
            if (intermediary == null || target == null) continue;
            inverse.put((Object)intermediary.replace('/', '.'), (Object)target.replace('/', '.'));
        }
        return inverse;
    });
    private final Supplier<BiMap<String, String>> intermediaryFromClassMap = Suppliers.memoize(() -> {
        MappingTreeView mappings = MappingsManager.runtimeMappings();
        HashBiMap inverse = HashBiMap.create();
        for (MappingTreeView.ClassMappingView def : mappings.getClasses()) {
            String intermediary = def.getName("intermediary");
            String target = def.getName(MappingsManager.runtimeNamespace());
            if (intermediary == null || target == null) continue;
            inverse.put((Object)target.replace('/', '.'), (Object)intermediary.replace('/', '.'));
        }
        return inverse;
    });
    private final Supplier<Map<String, String>> intermediaryToFieldMap = Suppliers.memoize(() -> {
        MappingTreeView mappings = MappingsManager.runtimeMappings();
        HashMap<String, String> map = new HashMap<String, String>();
        for (MappingTreeView.ClassMappingView klass : mappings.getClasses()) {
            for (MappingTreeView.FieldMappingView field : klass.getFields()) {
                map.put(field.getName("intermediary"), field.getName(MappingsManager.runtimeNamespace()));
            }
        }
        return map;
    });
    private final Supplier<Map<String, String>> fieldIdToIntermediary = Suppliers.memoize(() -> MappingUtils.createFieldIdUnmap(MappingsManager.runtimeMappings(), MappingsManager.runtimeNamespace()));

    private LocalMappings() {
    }

    @Override
    public String mapClass(String src) {
        return (String)this.intermediaryToClassMap.get().getOrDefault((Object)src, (Object)src);
    }

    @Override
    public String mapField(String src) {
        return this.intermediaryToFieldMap.get().getOrDefault(src, src);
    }

    @Override
    public String unmapClass(String dst) {
        return (String)this.intermediaryFromClassMap.get().getOrDefault((Object)dst, (Object)dst);
    }

    @Override
    public String unmapFieldId(String dst) {
        return this.fieldIdToIntermediary.get().getOrDefault(dst, dst);
    }

    @Override
    public void load(MappingVisitor visitor) throws IOException {
        MappingsManager.runtimeMappings().accept(visitor);
    }
}

