/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;

public final class MappingUtils {
    private MappingUtils() {
    }

    public static Map<String, String> createFieldIdUnmap(MappingTreeView tree, String to) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (MappingTreeView.ClassMappingView klass : tree.getClasses()) {
            String fromName = klass.getName("intermediary");
            if (fromName == null) {
                fromName = klass.getSrcName();
            }
            fromName = fromName.replace('/', '.');
            for (MappingTreeView.FieldMappingView field : klass.getFields()) {
                String intermediary = fromName + "#" + field.getName("intermediary");
                String local = klass.getName(to).replace('/', '.') + "#" + field.getName(to);
                map.put(local, intermediary);
            }
        }
        return map;
    }

    public static String fieldTargetName(MappingTree tree, int srcId, int dstId, String owner, String name, String desc, boolean defaultToOriginal) {
        MappingTree.ClassMapping treeC = tree.getClass(owner, srcId);
        if (treeC == null) {
            return defaultToOriginal ? name : null;
        }
        MappingTree.FieldMapping treeF = treeC.getField(name, desc, srcId);
        if (treeF == null) {
            return defaultToOriginal ? name : null;
        }
        String targetName = treeF.getName(dstId);
        return targetName != null || !defaultToOriginal ? targetName : name;
    }

    public static String methodTargetName(MappingTree tree, int srcId, int dstId, String owner, String name, String desc, boolean defaultToOriginal) {
        MappingTree.ClassMapping treeC = tree.getClass(owner, srcId);
        if (treeC == null) {
            return defaultToOriginal ? name : null;
        }
        MappingTree.MethodMapping treeM = treeC.getMethod(name, desc, srcId);
        if (treeM == null) {
            return defaultToOriginal ? name : null;
        }
        String targetName = treeM.getName(dstId);
        return targetName != null || !defaultToOriginal ? targetName : name;
    }
}

