/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import com.google.common.base.Suppliers;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.mappings.LocalMappings;
import io.wispforest.gadget.mappings.Mappings;
import io.wispforest.gadget.util.GadgetConfigModel;
import io.wispforest.gadget.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"gadget/MappingsManager");
    @Nullable
    private static MappingTreeView runtimeMappings;
    private static final Supplier<Map<String, MappingTreeView.ClassMappingView>> intermediaryClassMap;
    private static Mappings DISPLAY_MAPPINGS;
    private static boolean initted;

    private MappingsManager() {
    }

    public static void init() {
        if (initted) {
            return;
        }
        initted = true;
        MappingsManager.reloadMappings();
        Gadget.CONFIG.subscribeToMappings(type -> MappingsManager.reloadMappings());
        CompletableFuture.runAsync(MappingsManager::runtimeMappings).exceptionally(e -> {
            Gadget.LOGGER.error("Encountered error while loading runtime mappings", e);
            return null;
        });
    }

    public static void reloadMappings() {
        try {
            DISPLAY_MAPPINGS = Gadget.CONFIG.mappings().factory().get();
        }
        catch (Exception e) {
            LOGGER.error("Encountered error while loading {} mappings", (Object)Gadget.CONFIG.mappings(), (Object)e);
            Gadget.CONFIG.mappings(GadgetConfigModel.MappingsType.LOCAL);
            DISPLAY_MAPPINGS = LocalMappings.INSTANCE;
        }
    }

    public static String runtimeNamespace() {
        return FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
    }

    public static MappingTreeView runtimeMappings() {
        MemoryMappingTree memoryMappingTree;
        block10: {
            if (runtimeMappings != null) {
                return runtimeMappings;
            }
            URL url = FabricLoader.class.getClassLoader().getResource("mappings/mappings.tiny");
            if (url == null) {
                runtimeMappings = new MemoryMappingTree();
                return runtimeMappings;
            }
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            try {
                MemoryMappingTree tree = new MemoryMappingTree();
                MappingReader.read((Reader)new InputStreamReader(is), (MappingVisitor)tree);
                runtimeMappings = tree;
                memoryMappingTree = runtimeMappings;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Gadget.LOGGER.error("Couldn't load runtime mappings!", (Throwable)e);
                    runtimeMappings = new MemoryMappingTree();
                    return runtimeMappings;
                }
            }
            is.close();
        }
        return memoryMappingTree;
    }

    public static Mappings displayMappings() {
        return DISPLAY_MAPPINGS;
    }

    public static String remapClassToDisplay(Class<?> klass) {
        return MappingsManager.displayMappings().mapClass(MappingsManager.unmapClass(klass));
    }

    public static String unmapClass(Class<?> klass) {
        return MappingsManager.unmapClass(ReflectionUtil.prettyName(klass));
    }

    public static String unmapClass(String name) {
        if (name.contains("/")) {
            int slashIdx = name.lastIndexOf("/");
            return MappingsManager.unmapClass(name.substring(0, slashIdx)) + name.substring(slashIdx);
        }
        if (name.contains("$$")) {
            int dollarDollarIdx = name.lastIndexOf("$$");
            return MappingsManager.unmapClass(name.substring(0, dollarDollarIdx)) + name.substring(dollarDollarIdx);
        }
        return FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", name);
    }

    public static String unmapField(Field field) {
        if (!FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace().equals("named")) {
            return field.getName();
        }
        String ownerUnmapped = MappingsManager.unmapClass(field.getDeclaringClass());
        MappingTreeView.ClassMappingView owner = intermediaryClassMap.get().get(ownerUnmapped.replace('.', '/'));
        if (owner == null) {
            return field.getName();
        }
        for (MappingTreeView.FieldMappingView other : owner.getFields()) {
            if (!other.getName(MappingsManager.runtimeNamespace()).equals(field.getName())) continue;
            return other.getName("intermediary");
        }
        return field.getName();
    }

    static {
        intermediaryClassMap = Suppliers.memoize(() -> {
            MappingTreeView mappings = MappingsManager.runtimeMappings();
            HashMap<String, MappingTreeView.ClassMappingView> inverse = new HashMap<String, MappingTreeView.ClassMappingView>();
            for (MappingTreeView.ClassMappingView def : mappings.getClasses()) {
                inverse.put(def.getName("intermediary"), def);
            }
            return inverse;
        });
        DISPLAY_MAPPINGS = LocalMappings.INSTANCE;
        initted = false;
    }
}

