/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.wispforest.gadget.mappings.IntermediaryLoader;
import io.wispforest.gadget.mappings.LoadingMappings;
import io.wispforest.gadget.util.DownloadUtil;
import io.wispforest.gadget.util.ProgressToast;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.proguard.ProGuardFileReader;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3518;

public class MojangMappings
extends LoadingMappings {
    public static final String VERSION_MANIFEST_ENDPOINT = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";

    @Override
    protected void load(ProgressToast toast, MappingVisitor visitor) {
        try {
            Path mappingsDir = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("mappings");
            Files.createDirectories(mappingsDir, new FileAttribute[0]);
            Path mojPath = mappingsDir.resolve("mojmap-" + class_155.method_16673().comp_4025() + ".tiny");
            if (Files.exists(mojPath, new LinkOption[0])) {
                try (BufferedReader br = Files.newBufferedReader(mojPath);){
                    Tiny2FileReader.read((Reader)br, (MappingVisitor)visitor);
                    return;
                }
            }
            MemoryMappingTree tree = new MemoryMappingTree(true);
            IntermediaryLoader.loadIntermediary(toast, (MappingVisitor)tree);
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_minecraft_versions"));
            JsonArray versions = class_3518.method_15261((JsonObject)DownloadUtil.read(toast, VERSION_MANIFEST_ENDPOINT), (String)"versions");
            String chosenUrl = null;
            for (int i = 0; i < versions.size(); ++i) {
                JsonObject version = versions.get(i).getAsJsonObject();
                if (!class_3518.method_15265((JsonObject)version, (String)"id").equals(class_155.method_16673().comp_4024())) continue;
                chosenUrl = class_3518.method_15265((JsonObject)version, (String)"url");
            }
            if (chosenUrl == null) {
                throw new UnsupportedOperationException("Couldn't find version " + class_155.method_16673().comp_4024() + " on Mojang's servers!");
            }
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_minecraft_version_manifest"));
            JsonObject manifest = DownloadUtil.read(toast, chosenUrl);
            JsonObject downloads = class_3518.method_15296((JsonObject)manifest, (String)"downloads");
            JsonObject clientMappings = class_3518.method_15296((JsonObject)downloads, (String)"client_mappings");
            JsonObject serverMappings = class_3518.method_15296((JsonObject)downloads, (String)"server_mappings");
            MappingSourceNsSwitch sw = new MappingSourceNsSwitch((MappingVisitor)tree, "official");
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_client_mappings"));
            this.readProGuardInto(toast, class_3518.method_15265((JsonObject)clientMappings, (String)"url"), (MappingVisitor)sw);
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_server_mappings"));
            this.readProGuardInto(toast, class_3518.method_15265((JsonObject)serverMappings, (String)"url"), (MappingVisitor)sw);
            try (BufferedWriter bw = Files.newBufferedWriter(mojPath, new OpenOption[0]);){
                tree.accept((MappingVisitor)new Tiny2FileWriter((Writer)bw, false));
            }
            tree.accept(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readProGuardInto(ProgressToast toast, String url, MappingVisitor visitor) throws IOException {
        try (InputStream is = toast.loadWithProgress(new URL(url));){
            ProGuardFileReader.read((Reader)new InputStreamReader(new BufferedInputStream(is)), (String)"named", (String)"official", (MappingVisitor)visitor);
        }
    }
}

