/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import io.wispforest.gadget.mappings.IntermediaryLoader;
import io.wispforest.gadget.mappings.LoadingMappings;
import io.wispforest.gadget.util.DownloadUtil;
import io.wispforest.gadget.util.ProgressToast;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraft.class_155;
import net.minecraft.class_2561;

public class QuiltMappings
extends LoadingMappings {
    private static final String QM_API_ENTRYPOINT = "https://meta.quiltmc.org/v3/versions/quilt-mappings/" + class_155.method_16673().comp_4024();

    @Override
    protected void load(ProgressToast toast, MappingVisitor visitor) {
        try {
            Path mappingsDir = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("mappings");
            Files.createDirectories(mappingsDir, new FileAttribute[0]);
            Path qmPath = mappingsDir.resolve("qm-" + class_155.method_16673().comp_4024() + ".tiny");
            if (Files.exists(qmPath, new LinkOption[0])) {
                try (BufferedReader br = Files.newBufferedReader(qmPath);){
                    Tiny2FileReader.read((Reader)br, (MappingVisitor)visitor);
                    return;
                }
            }
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_qm_versions"));
            QMVersion[] versions = DownloadUtil.read(toast, QM_API_ENTRYPOINT, QMVersion[].class);
            if (versions.length == 0) {
                throw new IllegalStateException("we malden");
            }
            int latestBuild = -1;
            String latestVersion = "";
            for (QMVersion version : versions) {
                if (version.build <= latestBuild) continue;
                latestVersion = version.version;
                latestBuild = version.build;
            }
            MemoryMappingTree tree = new MemoryMappingTree();
            IntermediaryLoader.loadIntermediary(toast, (MappingVisitor)tree);
            URL url = new URL("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-mappings/" + latestVersion + "/quilt-mappings-" + latestVersion + "-tiny.gz");
            toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_qm"));
            try (InputStream is = toast.loadWithProgress(url);
                 GZIPInputStream gz = new GZIPInputStream(is);){
                Tiny2FileReader.read((Reader)new InputStreamReader(gz), (MappingVisitor)tree);
            }
            try (BufferedWriter bw = Files.newBufferedWriter(qmPath, new OpenOption[0]);){
                tree.accept((MappingVisitor)new Tiny2FileWriter((Writer)bw, false));
            }
            tree.accept(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class QMVersion {
        private int build;
        private String version;

        private QMVersion() {
        }
    }
}

