/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mappings;

import io.wispforest.gadget.mappings.LoadingMappings;
import io.wispforest.gadget.util.DownloadUtil;
import io.wispforest.gadget.util.ProgressToast;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;

public class YarnMappings
extends LoadingMappings {
    private static final String YARN_API_ENTRYPOINT = "https://meta.fabricmc.net/v2/versions/yarn/" + class_155.method_16673().comp_4024();

    @Override
    protected void load(ProgressToast toast, MappingVisitor visitor) {
        try {
            Path mappingsDir = FabricLoader.getInstance().getGameDir().resolve("gadget").resolve("mappings");
            Files.createDirectories(mappingsDir, new FileAttribute[0]);
            Path yarnPath = mappingsDir.resolve("yarn-" + class_155.method_16673().comp_4024() + ".jar");
            if (!Files.exists(yarnPath, new LinkOption[0])) {
                toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_yarn_versions"));
                YarnVersion[] versions = DownloadUtil.read(toast, YARN_API_ENTRYPOINT, YarnVersion[].class);
                if (versions.length == 0) {
                    throw new IllegalStateException("we malden");
                }
                int latestBuild = -1;
                String latestVersion = "";
                for (YarnVersion version : versions) {
                    if (version.build <= latestBuild) continue;
                    latestVersion = version.version;
                    latestBuild = version.build;
                }
                toast.step((class_2561)class_2561.method_43471((String)"message.gadget.progress.downloading_yarn"));
                try (InputStream is = toast.loadWithProgress(new URL("https://maven.fabricmc.net/net/fabricmc/yarn/" + latestVersion + "/yarn-" + latestVersion + "-v2.jar"));){
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)yarnPath.toFile());
                }
            }
            try (FileSystem fs = FileSystems.newFileSystem(yarnPath, (ClassLoader)null);
                 BufferedReader br = Files.newBufferedReader(fs.getPath("mappings/mappings.tiny", new String[0]));){
                Tiny2FileReader.read((Reader)br, (MappingVisitor)visitor);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class YarnVersion {
        private int build;
        private String version;

        private YarnVersion() {
        }
    }
}

