/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.mixin.owo;

import io.wispforest.gadget.Gadget;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.ParentComponent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Component.class}, remap=false)
public interface ComponentMixin {
    @Shadow
    @Nullable
    public ParentComponent parent();

    @Inject(method={"remove"}, at={@At(value="HEAD")}, cancellable=true)
    private void remove(CallbackInfo ci) {
        if (!Gadget.CONFIG.errorCheckOwoUi()) {
            return;
        }
        ci.cancel();
        ParentComponent currentParent = this.parent();
        if (currentParent == null) {
            return;
        }
        Throwable context = new Throwable("Component#remove was called here");
        currentParent.queue(() -> {
            ParentComponent newParent = this.parent();
            if (newParent != currentParent) {
                throw new IllegalStateException("Component " + String.valueOf(this) + "'s parent changed from " + String.valueOf(currentParent) + " to " + String.valueOf(newParent) + " after Component$remove() call", context);
            }
            currentParent.removeChild((Component)this);
        });
    }
}

