/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.network;

import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.desc.FieldObject;
import io.wispforest.gadget.desc.FieldObjects;
import io.wispforest.gadget.desc.edit.PrimitiveEditType;
import io.wispforest.gadget.desc.edit.PrimitiveEditTypes;
import io.wispforest.gadget.network.FieldData;
import io.wispforest.gadget.network.packet.c2s.FieldDataRequestC2SPacket;
import io.wispforest.gadget.network.packet.c2s.FieldDataSetNbtCompoundC2SPacket;
import io.wispforest.gadget.network.packet.c2s.FieldDataSetPrimitiveC2SPacket;
import io.wispforest.gadget.network.packet.c2s.ListResourcesC2SPacket;
import io.wispforest.gadget.network.packet.c2s.OpenFieldDataScreenC2SPacket;
import io.wispforest.gadget.network.packet.c2s.ReplaceStackC2SPacket;
import io.wispforest.gadget.network.packet.c2s.RequestResourceC2SPacket;
import io.wispforest.gadget.network.packet.s2c.AnnounceS2CPacket;
import io.wispforest.gadget.network.packet.s2c.FieldDataErrorS2CPacket;
import io.wispforest.gadget.network.packet.s2c.FieldDataResponseS2CPacket;
import io.wispforest.gadget.network.packet.s2c.OpenFieldDataScreenS2CPacket;
import io.wispforest.gadget.network.packet.s2c.ResourceDataS2CPacket;
import io.wispforest.gadget.network.packet.s2c.ResourceListS2CPacket;
import io.wispforest.gadget.path.EnumMapPathStepType;
import io.wispforest.gadget.path.PathStep;
import io.wispforest.gadget.path.SimpleMapPathStepType;
import io.wispforest.gadget.util.ResourceUtil;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5250;

public final class GadgetNetworking {
    public static final OwoNetChannel CHANNEL = OwoNetChannel.createOptional((class_2960)Gadget.id("data")).addEndecs(GadgetNetworking::registerEndecs);

    private GadgetNetworking() {
    }

    public static void init() {
        PrimitiveEditTypes.init();
        CHANNEL.registerServerbound(OpenFieldDataScreenC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.inspect", (int)4)) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.permissions"), true);
                return;
            }
            Object target = packet.target().resolve((class_1937)access.player().method_51469());
            if (target == null) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.notfound"), true);
                return;
            }
            FieldObject data = FieldObjects.fromObject(target, Set.of());
            Map<PathStep, FieldData> fields = FieldObjects.getData(target, (Set<Object>)ReferenceSets.singleton((Object)target), 0, -1);
            CHANNEL.serverHandle((class_1657)access.player()).send((Record)new OpenFieldDataScreenS2CPacket(packet.target(), new FieldData(data, false, true), fields));
        });
        CHANNEL.registerServerbound(FieldDataRequestC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.inspect", (int)4)) {
                class_5250 errText = class_2561.method_43471((String)"message.gadget.fail.permissions");
                CHANNEL.serverHandle((class_1657)access.player()).send((Record)packet.replyWithError((class_2561)errText));
                access.player().method_7353((class_2561)errText, true);
                return;
            }
            try {
                Object target = packet.target().resolve((class_1937)access.player().method_51469());
                if (target == null) {
                    class_5250 errText = class_2561.method_43471((String)"message.gadget.fail.notfound");
                    CHANNEL.serverHandle((class_1657)access.player()).send((Record)packet.replyWithError((class_2561)errText));
                    access.player().method_7353((class_2561)errText, true);
                    return;
                }
                Object[] real = packet.path().toRealPath(target);
                Map<PathStep, FieldData> fields = FieldObjects.getData(real[real.length - 1], (Set<Object>)new ReferenceOpenHashSet(real), packet.from(), packet.limit());
                CHANNEL.serverHandle((class_1657)access.player()).send((Record)new FieldDataResponseS2CPacket(packet.target(), packet.path(), fields));
            }
            catch (Exception e) {
                class_5250 errText = class_2561.method_43470((String)e.toString());
                CHANNEL.serverHandle((class_1657)access.player()).send((Record)packet.replyWithError((class_2561)errText));
                Gadget.LOGGER.error("Encountered error while gathering field data for {}.{}", new Object[]{packet.target(), packet.path(), e});
                access.player().method_7353((class_2561)errText, true);
            }
        });
        CHANNEL.registerServerbound(FieldDataSetPrimitiveC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.inspect", (int)4)) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.permissions"), true);
                return;
            }
            Object target = packet.target().resolve((class_1937)access.player().method_51469());
            if (target == null) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.notfound"), true);
                return;
            }
            packet.path().set(target, packet.data().toObject());
        });
        CHANNEL.registerServerbound(FieldDataSetNbtCompoundC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.inspect", (int)4)) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.permissions"), true);
                return;
            }
            Object target = packet.target().resolve((class_1937)access.player().method_51469());
            if (target == null) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.notfound"), true);
                return;
            }
            packet.path().set(target, packet.data());
        });
        CHANNEL.registerServerbound(ReplaceStackC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.replaceStack", (int)4)) {
                access.player().method_64398((class_2561)class_2561.method_43471((String)"message.gadget.fail.permissions"));
                return;
            }
            class_1703 screenHandler = access.player().field_7512;
            if (screenHandler == null) {
                return;
            }
            ((class_1735)screenHandler.field_7761.get(packet.slotId())).method_53512(packet.stack());
        });
        CHANNEL.registerServerbound(ListResourcesC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.requestServerData", (int)4)) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.permissions"), true);
                return;
            }
            Map<class_2960, List<class_3298>> resources = ResourceUtil.collectAllResources(access.runtime().method_34864());
            HashMap<class_2960, Integer> network = new HashMap<class_2960, Integer>();
            for (Map.Entry<class_2960, List<class_3298>> entry : resources.entrySet()) {
                network.put(entry.getKey(), entry.getValue().size());
            }
            CHANNEL.serverHandle((class_1657)access.player()).send((Record)new ResourceListS2CPacket(network));
        });
        CHANNEL.registerServerbound(RequestResourceC2SPacket.class, (packet, access) -> {
            if (!Permissions.check((class_1297)access.player(), (String)"gadget.requestServerData", (int)4)) {
                access.player().method_7353((class_2561)class_2561.method_43471((String)"message.gadget.fail.permissions"), true);
                return;
            }
            List resources = access.runtime().method_34864().method_14489(packet.id());
            try {
                CHANNEL.serverHandle((class_1657)access.player()).send((Record)new ResourceDataS2CPacket(packet.id(), ((class_3298)resources.get(packet.index())).method_14482().readAllBytes()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        CHANNEL.registerClientboundDeferred(OpenFieldDataScreenS2CPacket.class);
        CHANNEL.registerClientboundDeferred(FieldDataResponseS2CPacket.class);
        CHANNEL.registerClientboundDeferred(FieldDataErrorS2CPacket.class);
        CHANNEL.registerClientboundDeferred(AnnounceS2CPacket.class);
        CHANNEL.registerClientboundDeferred(ResourceListS2CPacket.class);
        CHANNEL.registerClientboundDeferred(ResourceDataS2CPacket.class);
    }

    public static void registerEndecs(ReflectiveEndecBuilder builder) {
        builder.register(EnumMapPathStepType.ENDEC, EnumMapPathStepType.class);
        builder.register(SimpleMapPathStepType.ENDEC, SimpleMapPathStepType.class);
        builder.register(PrimitiveEditType.ENDEC, PrimitiveEditType.class);
        builder.register(NbtEndec.COMPOUND, class_2487.class);
    }
}

