/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.path;

import io.wispforest.gadget.mappings.LocalMappings;
import io.wispforest.gadget.mappings.MappingsManager;
import io.wispforest.gadget.path.PathStep;
import java.lang.reflect.Field;
import net.auoeke.reflect.Accessor;

public record FieldPathStep(String className, String fieldName) implements PathStep
{
    public static FieldPathStep forField(Field field) {
        return new FieldPathStep(MappingsManager.unmapClass(field.getDeclaringClass()), MappingsManager.unmapField(field));
    }

    public String runtimeName() {
        if (!this.fieldName.startsWith("field_") && !this.fieldName.startsWith("comp_")) {
            return this.fieldName;
        }
        return LocalMappings.INSTANCE.mapField(this.fieldName);
    }

    public String fieldId() {
        return this.className + "#" + this.fieldName;
    }

    @Override
    public Object follow(Object o) {
        return Accessor.get((Object)o, (String)this.runtimeName());
    }

    @Override
    public void set(Object o, Object to) {
        Accessor.put((Object)o, (String)this.runtimeName(), (Object)to);
    }

    @Override
    public String toString() {
        if (!this.fieldName.startsWith("field_") && !this.fieldName.startsWith("comp_")) {
            return this.fieldName;
        }
        return MappingsManager.displayMappings().mapField(this.fieldName);
    }

    public static String remapFieldId(String id) {
        if (!id.contains("#")) {
            return id;
        }
        int hashIdx = id.lastIndexOf(35);
        String klass = id.substring(0, hashIdx);
        String field = id.substring(hashIdx + 1);
        return MappingsManager.displayMappings().mapClass(klass) + "#" + MappingsManager.displayMappings().mapField(field);
    }
}

