/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.path;

import io.wispforest.gadget.path.PathStep;
import org.jetbrains.annotations.NotNull;

public record ObjectPath(PathStep[] steps) implements Comparable<ObjectPath>
{
    public static final ObjectPath EMPTY = new ObjectPath(new PathStep[0]);

    public Object follow(Object o) {
        for (PathStep step : this.steps) {
            o = step.follow(o);
        }
        return o;
    }

    public Object[] toRealPath(Object o) {
        Object[] real = new Object[this.steps.length + 1];
        real[0] = o;
        for (int i = 0; i < this.steps.length; ++i) {
            real[i + 1] = this.steps[i].follow(real[i]);
        }
        return real;
    }

    public void set(Object o, Object to) {
        for (int i = 0; i < this.steps.length - 1; ++i) {
            o = this.steps[i].follow(o);
        }
        this.steps[this.steps.length - 1].set(o, to);
    }

    public String name() {
        return this.steps[this.steps.length - 1].toString();
    }

    public ObjectPath parent() {
        PathStep[] newSteps = new PathStep[this.steps.length - 1];
        System.arraycopy(this.steps, 0, newSteps, 0, this.steps.length - 1);
        return new ObjectPath(newSteps);
    }

    public ObjectPath then(PathStep step) {
        PathStep[] newSteps = new PathStep[this.steps.length + 1];
        System.arraycopy(this.steps, 0, newSteps, 0, this.steps.length);
        newSteps[newSteps.length - 1] = step;
        return new ObjectPath(newSteps);
    }

    @Override
    public int compareTo(@NotNull ObjectPath o) {
        for (int i = 0; i < o.steps.length && i < this.steps.length; ++i) {
            int compared = this.steps[i].toString().compareTo(o.steps[i].toString());
            if (compared == 0) continue;
            return compared;
        }
        return this.steps.length - o.steps.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.steps.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(this.steps[i].toString());
        }
        return sb.toString();
    }

    public PathStep last() {
        return this.steps[this.steps.length - 1];
    }
}

