/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import io.wispforest.gadget.util.CancellationTokenSource;
import io.wispforest.gadget.util.InfallibleClosable;
import java.lang.ref.WeakReference;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;

public class CancellationToken {
    public static final CancellationToken NONE = new CancellationToken();
    private final WeakReference<CancellationTokenSource> sourceRef;
    boolean cancelled = false;

    CancellationToken(CancellationTokenSource source) {
        this.sourceRef = new WeakReference<CancellationTokenSource>(source);
    }

    private CancellationToken() {
        this.sourceRef = new WeakReference<Object>(null);
        this.cancelled = false;
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public void throwIfCancelled() {
        if (this.cancelled()) {
            throw new CancellationException();
        }
    }

    public <T> CompletableFuture<T> wrapFuture(CompletableFuture<T> original) {
        if (!original.isDone()) {
            Subscription subscription = this.register(() -> {
                if (this.cancelled()) {
                    original.cancel(true);
                }
            });
            original.whenComplete((unused1, unused2) -> subscription.close());
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription register(Runnable action) {
        if (this.cancelled) {
            action.run();
            return Subscription.EMPTY;
        }
        CancellationTokenSource source = (CancellationTokenSource)this.sourceRef.get();
        if (source == null) {
            return Subscription.EMPTY;
        }
        Object object = source.lock;
        synchronized (object) {
            if (source.listeners == null) {
                action.run();
                return Subscription.EMPTY;
            }
            source.listeners.add(action);
            return new Subscription(this, action);
        }
    }

    public static class Subscription
    implements InfallibleClosable {
        private static final Subscription EMPTY = new Subscription(null, null);
        private CancellationToken token;
        private Runnable runnable;

        public Subscription(CancellationToken token, Runnable runnable) {
            this.token = token;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.token != null) {
                if (this.token.cancelled()) {
                    this.token = null;
                    this.runnable = null;
                    return;
                }
                CancellationTokenSource source = (CancellationTokenSource)this.token.sourceRef.get();
                if (source == null) {
                    this.token = null;
                    this.runnable = null;
                    return;
                }
                Object object = source.lock;
                synchronized (object) {
                    if (source.listeners == null) {
                        this.token = null;
                        this.runnable = null;
                        return;
                    }
                    source.listeners.remove(this.runnable);
                    this.token = null;
                    this.runnable = null;
                }
            }
        }
    }
}

