/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.wispforest.gadget.util.ProgressToast;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public final class DownloadUtil {
    private static final Gson GSON = new Gson();

    private DownloadUtil() {
    }

    public static <T> T read(ProgressToast toast, String url, Class<T> klass) throws IOException {
        try (InputStream is = toast.loadWithProgress(new URL(url));){
            Object object = GSON.fromJson((Reader)new InputStreamReader(new BufferedInputStream(is)), klass);
            return (T)object;
        }
    }

    public static JsonObject read(ProgressToast toast, String url) throws IOException {
        try (InputStream is = toast.loadWithProgress(new URL(url));){
            JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(new BufferedInputStream(is))).getAsJsonObject();
            return jsonObject;
        }
    }
}

