/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import java.io.PrintStream;

public record FormattedDumper(PrintStream out) {
    public void write(int indent, String text) {
        for (int i = 0; i < indent; ++i) {
            this.out.write(32);
        }
        this.out.println(text);
    }

    public void writeLines(int indent, String text) {
        text.lines().forEach(line -> this.write(indent, (String)line));
    }

    public void writeHexDump(int indent, byte[] bytes) {
        int index = 0;
        while (index < bytes.length) {
            int i;
            StringBuilder line = new StringBuilder();
            line.append(String.format("%04x  ", index));
            for (i = 0; i < 16 && index < bytes.length; ++index, ++i) {
                short b = (short)(bytes[index] & 0xFF);
                line.append(String.format("%02x ", b));
            }
            line.append("   ".repeat(Math.max(0, 16 - i)));
            for (int j = 0; j < i; ++j) {
                short b = (short)(bytes[index - i + j] & 0xFF);
                if (b >= 32 && b < 127) {
                    line.append((char)b);
                    continue;
                }
                line.append('.');
            }
            this.write(indent, line.toString());
        }
    }
}

