/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import io.wispforest.gadget.decompile.QuiltflowerVersions;
import io.wispforest.gadget.mappings.LocalMappings;
import io.wispforest.gadget.mappings.Mappings;
import io.wispforest.gadget.mappings.MojangMappings;
import io.wispforest.gadget.mappings.QuiltMappings;
import io.wispforest.gadget.mappings.YarnMappings;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Hook;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.PredicateConstraint;
import io.wispforest.owo.config.annotation.RestartRequired;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;

@Config(name="gadget", wrapperName="GadgetConfig")
public class GadgetConfigModel {
    public boolean menuButtonEnabled = true;
    public boolean rightClickDump = true;
    public boolean dropChunkData = false;
    public DumpSafetyMode dumpSafety = DumpSafetyMode.ON_EXIT;
    public boolean debugKeysInScreens = true;
    public boolean matrixStackDebugging = true;
    @RestartRequired
    public boolean silenceStartupErrors = true;
    @PredicateConstraint(value="isQuiltflowerVersionValid")
    public String quiltflowerVersion = "LATEST";
    @PredicateConstraint(value="isMappingsValid")
    @Hook
    public MappingsType mappings = FabricLoader.getInstance().isDevelopmentEnvironment() ? MappingsType.LOCAL : MappingsType.YARN;
    public boolean inspectClasses = true;
    public boolean fullDecompilationContext = true;
    @Hook
    public List<String> hiddenFields = new ArrayList<String>(List.of("java.lang.Enum#name", "java.util.ArrayList#elementData", "java.util.ArrayList#size", "java.util.AbstractList#modCount", "java.util.AbstractMap#keySet", "java.util.AbstractMap#values", "java.util.EnumMap#entrySet", "java.util.EnumMap#size", "java.util.EnumMap#vals", "java.util.HashMap#table", "java.util.HashMap#size", "java.util.HashMap#modCount", "java.util.HashMap#loadFactor", "java.util.HashMap#threshold", "java.util.HashMap#entrySet", "java.util.HashMap$Node#hash", "java.util.HashMap$Node#next", "java.util.LinkedHashMap#accessOrder", "java.util.LinkedHashMap#head", "java.util.LinkedHashMap#tail", "java.util.LinkedHashMap$Entry#before", "java.util.LinkedHashMap$Entry#after", "java.util.IdentityHashMap#table", "java.util.IdentityHashMap#size", "java.util.IdentityHashMap#modCount", "java.util.IdentityHashMap#entrySet", "java.util.HashSet#map", "java.util.RegularEnumSet#elements", "java.util.EnumSet#elementType", "java.util.EnumSet#universe", "net.minecraft.class_2586#field_11866", "net.minecraft.class_2586#field_11865", "net.minecraft.class_2586#field_11864", "net.minecraft.class_1297#field_5961"));
    public boolean errorCheckOwoUi = false;
    @Nest
    public InternalSettings internalSettings = new InternalSettings();

    public static boolean isQuiltflowerVersionValid(String version) {
        if (version.equals("LATEST")) {
            return true;
        }
        if (!QuiltflowerVersions.versions().contains(version)) {
            return false;
        }
        try {
            SemanticVersion v = SemanticVersion.parse((String)version);
            return v.compareTo((Object)SemanticVersion.parse((String)"1.9.0")) >= 0;
        }
        catch (VersionParsingException e) {
            return false;
        }
    }

    public static boolean isMappingsValid(MappingsType type) {
        return type != MappingsType.LOCAL || FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace().equals("named");
    }

    public static enum DumpSafetyMode {
        ON_PAUSE(false, false),
        ON_EXIT(true, false),
        AFTER_EVERY_PACKET(true, true);

        private final boolean createExitHook;
        private final boolean flushAfterWrite;

        private DumpSafetyMode(boolean createExitHook, boolean flushAfterWrite) {
            this.createExitHook = createExitHook;
            this.flushAfterWrite = flushAfterWrite;
        }

        public boolean createExitHook() {
            return this.createExitHook;
        }

        public boolean flushAfterWrite() {
            return this.flushAfterWrite;
        }
    }

    public static enum MappingsType {
        LOCAL(() -> LocalMappings.INSTANCE),
        YARN(YarnMappings::new),
        MOJANG(MojangMappings::new),
        QUILT(QuiltMappings::new);

        private final Supplier<Mappings> factory;

        private MappingsType(Supplier<Mappings> factory) {
            this.factory = factory;
        }

        public Supplier<Mappings> factory() {
            return this.factory;
        }
    }

    public static class InternalSettings {
        public boolean debugMatrixStackDebugging = false;
        public boolean dumpTRMappings = false;
        public boolean dumpFieldDataRequests = false;
    }
}

