/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumberUtil {
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public static String formatDouble(double num) {
        return SIZE_FORMAT.format(num);
    }

    public static String formatPercent(double num) {
        return SIZE_FORMAT.format(num * 100.0) + "%";
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return SIZE_FORMAT.format((double)size / 1024.0) + " KB";
        }
        if (size < 0x40000000L) {
            return SIZE_FORMAT.format((double)size / 1024.0 / 1024.0) + " MB";
        }
        return SIZE_FORMAT.format((double)size / 1024.0 / 1024.0 / 1024.0) + " GB";
    }

    static {
        SIZE_FORMAT.setMaximumFractionDigits(2);
    }
}

