/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import io.wispforest.gadget.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public final class PrettyPrinters {
    private static final Map<Class<?>, Function<Object, String>> PRINTERS = new HashMap();

    private PrettyPrinters() {
    }

    public static String tryPrint(Object o) {
        if (o == null) {
            return "null";
        }
        Function<Object, String> printer = ReflectionUtil.findFor(o.getClass(), PRINTERS);
        if (printer != null) {
            return printer.apply(o);
        }
        return null;
    }

    @SafeVarargs
    public static <T> void register(Function<T, String> printer, Class<? extends T> ... classes) {
        for (Class<? extends T> klass : classes) {
            PRINTERS.put(klass, printer);
        }
    }

    static {
        PrettyPrinters.register(Object::toString, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Class.class, UUID.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, class_2680.class, class_3610.class, class_1937.class, class_2960.class);
        PrettyPrinters.register(x -> "\"" + x + "\"", String.class);
        PrettyPrinters.register(x -> "MinecraftServer", MinecraftServer.class);
        PrettyPrinters.register(x -> class_7923.field_41178.method_10221(x).toString(), class_1792.class);
        PrettyPrinters.register(x -> class_7923.field_41175.method_10221(x).toString(), class_2248.class);
        PrettyPrinters.register(x -> class_7923.field_41177.method_10221(x).toString(), class_1299.class);
        PrettyPrinters.register(x -> Objects.toString(class_7923.field_41181.method_10221(x), x.toString()), class_2591.class);
        PrettyPrinters.register(x -> Objects.toString(class_7923.field_41174.method_10221(x), x.toString()), class_1291.class);
    }
}

