/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import com.google.common.io.CountingInputStream;
import io.wispforest.gadget.Gadget;
import io.wispforest.gadget.client.gui.ProgressToastImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.LongSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public interface ProgressToast {
    public static ProgressToast create(class_2561 headText) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return new ProgressToastImpl(headText);
        }
        return ProgressToast.dummy();
    }

    public static ProgressToast dummy() {
        return new Dummy();
    }

    public void step(class_2561 var1);

    public void followProgress(LongSupplier var1, long var2);

    default public InputStream loadWithProgress(Path path) throws IOException {
        long size = Files.size(path);
        BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        if (size == 0L) {
            return bis;
        }
        CountingInputStream progress = new CountingInputStream((InputStream)bis);
        this.followProgress(() -> ((CountingInputStream)progress).getCount(), size);
        return progress;
    }

    default public InputStream loadWithProgress(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
        int total = connection.getContentLength();
        if (total == -1) {
            return is;
        }
        CountingInputStream progress = new CountingInputStream((InputStream)is);
        this.followProgress(() -> ((CountingInputStream)progress).getCount(), total);
        return progress;
    }

    public void force();

    public void finish(class_2561 var1, boolean var2);

    public void oom(OutOfMemoryError var1);

    default public CompletableFuture<Void> follow(CompletableFuture<Void> future, boolean closeImmediately) {
        return future.whenComplete((res, e) -> {
            if (e != null) {
                if (e instanceof OutOfMemoryError) {
                    OutOfMemoryError oom = (OutOfMemoryError)e;
                    this.oom(oom);
                    return;
                }
                if (e instanceof CancellationException || e.getCause() instanceof CancellationException) {
                    this.finish((class_2561)class_2561.method_43471((String)"message.gadget.progress.cancelled"), true);
                    return;
                }
                Gadget.LOGGER.error("Loading failed with exception", e);
                this.force();
                this.finish((class_2561)class_2561.method_43471((String)"message.gadget.progress.failed"), false);
            } else {
                this.finish((class_2561)class_2561.method_43471((String)"message.gadget.progress.finished"), closeImmediately);
            }
        });
    }

    public static class Dummy
    implements ProgressToast {
        @Override
        public void step(class_2561 text) {
        }

        @Override
        public void followProgress(LongSupplier stream, long total) {
        }

        @Override
        public void force() {
        }

        @Override
        public void finish(class_2561 text, boolean hideImmediately) {
        }

        @Override
        public void oom(OutOfMemoryError oom) {
        }
    }
}

