/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.gadget.util;

import io.wispforest.owo.util.Observable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class ReactiveUtils {
    private ReactiveUtils() {
    }

    public static <T> Observable<T> throttle(final Observable<T> wrapped, final long delayNanos, final Executor executor) {
        return new Observable<T>(wrapped.get()){
            private long previousUpdate;
            private boolean taskSent;
            {
                super(initial);
                this.previousUpdate = 0L;
                this.taskSent = false;
                wrapped.observe(newValue -> {
                    long now = System.nanoTime();
                    long passed = now - this.previousUpdate;
                    if (delayNanos > passed) {
                        if (this.taskSent) {
                            return;
                        }
                        this.taskSent = true;
                        CompletableFuture.delayedExecutor(delayNanos, TimeUnit.NANOSECONDS, executor).execute(() -> {
                            this.set(wrapped.get());
                            this.previousUpdate = System.nanoTime();
                            this.taskSent = false;
                        });
                    } else {
                        executor.execute(() -> this.set(newValue));
                        this.previousUpdate = now;
                    }
                });
            }
        };
    }
}

