/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.misc;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.base.api.SomethingOperator;
import site.siredvin.broccolium.modules.storage.item.ItemStorageUtils;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.common.entities.ShootedItemProjectile;
import site.siredvin.turtlematic.computercraft.operations.PowerOperation;
import site.siredvin.turtlematic.computercraft.operations.PowerOperationContext;
import site.siredvin.turtlematic.util.DataStorageObjects;
import site.siredvin.turtlematic.util.TurtleDispenseBehavior;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.boon.OperationBoon;
import site.siredvin.tweakium.modules.peripheral.boon.PeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.owner.TurtlePeripheralOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0018H\u0007J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0007R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006#"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/BowPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/owner/TurtlePeripheralOwner;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "<init>", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)V", "dispenseBehavior", "Lsite/siredvin/turtlematic/computercraft/peripheral/misc/BowPeripheral$RandomItemDispenseBehavior;", "getDispenseBehavior", "()Lsite/siredvin/turtlematic/computercraft/peripheral/misc/BowPeripheral$RandomItemDispenseBehavior;", "dispenseBehavior$delegate", "Lkotlin/Lazy;", "suppressedDispenseBehavior", "getSuppressedDispenseBehavior", "suppressedDispenseBehavior$delegate", "isEnabled", "", "()Z", "setAngle", "", "angle", "", "getAngle", "shoot", "Ldan200/computercraft/api/lua/MethodResult;", "power", "limit", "Ljava/util/Optional;", "", "suppressExtraLogic", "Companion", "RandomItemDispenseBehavior", "turtlematic-forge-1.20.1"})
public final class BowPeripheral
extends OwnedPeripheral<TurtlePeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy dispenseBehavior$delegate;
    @NotNull
    private final Lazy suppressedDispenseBehavior$delegate;
    @NotNull
    private static final String type = "bow";

    public BowPeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        super(type, (IPeripheralOwner)new TurtlePeripheralOwner(turtle, side));
        ((TurtlePeripheralOwner)this.getPeripheralOwner()).attachOperations(1.0, TurtlematicConfig.INSTANCE.getCooldownTresholdLevel());
        TurtlePeripheralOwner.attachFuel$default((TurtlePeripheralOwner)((TurtlePeripheralOwner)this.getPeripheralOwner()), (int)0, (int)1, null);
        OperationBoon operationBoon = (OperationBoon)((TurtlePeripheralOwner)this.getPeripheralOwner()).getBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getOPERATION());
        if (operationBoon != null) {
            operationBoon.registerOperation((IPeripheralOperation)PowerOperation.SHOOT);
        }
        this.dispenseBehavior$delegate = LazyKt.lazy(() -> BowPeripheral.dispenseBehavior_delegate$lambda$0(this));
        this.suppressedDispenseBehavior$delegate = LazyKt.lazy(() -> BowPeripheral.suppressedDispenseBehavior_delegate$lambda$1(this));
    }

    private final RandomItemDispenseBehavior getDispenseBehavior() {
        Lazy lazy = this.dispenseBehavior$delegate;
        return (RandomItemDispenseBehavior)lazy.getValue();
    }

    private final RandomItemDispenseBehavior getSuppressedDispenseBehavior() {
        Lazy lazy = this.suppressedDispenseBehavior$delegate;
        return (RandomItemDispenseBehavior)lazy.getValue();
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableBowTurtle();
    }

    @LuaFunction(mainThread=true)
    public final void setAngle(double angle) {
        DataStorageObjects.Angle.INSTANCE.set(this.getPeripheralOwner(), angle);
    }

    @LuaFunction(mainThread=true)
    public final double getAngle() {
        return ((Number)DataStorageObjects.Angle.INSTANCE.get(this.getPeripheralOwner())).doubleValue();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult shoot(double power, @NotNull Optional<Integer> limit, @NotNull Optional<Boolean> suppressExtraLogic) {
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(suppressExtraLogic, (String)"suppressExtraLogic");
        if (power <= 0.0) {
            throw new LuaException("Power cannot be equal or less then 0");
        }
        double limitedPower = RangesKt.coerceAtMost((double)power, (double)TurtlematicConfig.INSTANCE.getBowTurtlePowerLimit());
        double currentAngle = Math.toRadians(((Number)DataStorageObjects.Angle.INSTANCE.get(this.getPeripheralOwner())).doubleValue());
        int selectedSlot = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getSelectedSlot();
        Container container = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack selectedStack = itemStack;
        if (selectedStack.m_41619_()) {
            Object[] objectArray = new Object[]{null, "Nothing to shoot"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Integer realLimit = limit.orElse(selectedStack.m_41613_());
        if (realLimit <= 0) {
            throw new LuaException("Limit should be positive integer");
        }
        return IPeripheralOwner.DefaultImpls.withOperation$default((IPeripheralOwner)this.getPeripheralOwner(), (IPeripheralOperation)PowerOperation.SHOOT, (Object)new PowerOperationContext(limitedPower), arg_0 -> BowPeripheral.shoot$lambda$2(selectedStack, realLimit, suppressExtraLogic, this, limitedPower, currentAngle, turtleInventory, selectedSlot, arg_0), null, null, null, (int)56, null);
    }

    private static final RandomItemDispenseBehavior dispenseBehavior_delegate$lambda$0(BowPeripheral this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new RandomItemDispenseBehavior(false, this$0.getPeripheralOwner());
    }

    private static final RandomItemDispenseBehavior suppressedDispenseBehavior_delegate$lambda$1(BowPeripheral this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new RandomItemDispenseBehavior(true, this$0.getPeripheralOwner());
    }

    private static final MethodResult shoot$lambda$2(ItemStack $selectedStack, Integer $realLimit, Optional $suppressExtraLogic, BowPeripheral this$0, double $limitedPower, double $currentAngle, Container $turtleInventory, int $selectedSlot, PowerOperationContext it) {
        ItemStack dispensedResult;
        Intrinsics.checkNotNullParameter((Object)$selectedStack, (String)"$selectedStack");
        Intrinsics.checkNotNullParameter((Object)$suppressExtraLogic, (String)"$suppressExtraLogic");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$turtleInventory, (String)"$turtleInventory");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$realLimit);
        ItemStack stackToDispense = $selectedStack.m_41620_($realLimit.intValue());
        if ($suppressExtraLogic.orElse(false).booleanValue()) {
            RandomItemDispenseBehavior randomItemDispenseBehavior = this$0.getSuppressedDispenseBehavior();
            Level level = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            BlockSource blockSource = (BlockSource)new BlockSourceImpl((ServerLevel)level, ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos());
            Intrinsics.checkNotNull((Object)stackToDispense);
            v3 = randomItemDispenseBehavior.dispense(blockSource, stackToDispense, $limitedPower, $currentAngle);
        } else {
            RandomItemDispenseBehavior randomItemDispenseBehavior = this$0.getDispenseBehavior();
            Level level = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            BlockSource blockSource = (BlockSource)new BlockSourceImpl((ServerLevel)level, ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos());
            Intrinsics.checkNotNull((Object)stackToDispense);
            v3 = dispensedResult = randomItemDispenseBehavior.dispense(blockSource, stackToDispense, $limitedPower, $currentAngle);
        }
        if (!$selectedStack.m_41619_()) {
            if (!dispensedResult.m_41619_()) {
                SomethingOperator.DefaultImpls.inplaceMerge$default((SomethingOperator)((SomethingOperator)ItemStorageUtils.INSTANCE), (Object)$selectedStack, (Object)dispensedResult, null, (int)4, null);
            }
            $turtleInventory.m_6836_($selectedSlot, $selectedStack);
        } else {
            $turtleInventory.m_6836_($selectedSlot, dispensedResult);
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/BowPeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @Override
        @NotNull
        public ResourceLocation getUpgradeID() {
            return PeripheralConfiguration.DefaultImpls.getUpgradeID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/BowPeripheral$RandomItemDispenseBehavior;", "Lsite/siredvin/turtlematic/util/TurtleDispenseBehavior;", "suppressExtraLogic", "", "owner", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "<init>", "(ZLsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "getProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "level", "Lnet/minecraft/world/level/Level;", "targetPosition", "Lnet/minecraft/core/Position;", "stack", "Lnet/minecraft/world/item/ItemStack;", "turtlematic-forge-1.20.1"})
    public static final class RandomItemDispenseBehavior
    extends TurtleDispenseBehavior {
        private final boolean suppressExtraLogic;

        public RandomItemDispenseBehavior(boolean suppressExtraLogic, @NotNull IPeripheralOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner);
            this.suppressExtraLogic = suppressExtraLogic;
        }

        @Override
        @NotNull
        public Projectile getProjectile(@NotNull Level level, @NotNull Position targetPosition, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (!this.suppressExtraLogic) {
                if (stack.m_150930_(Items.f_42737_)) {
                    AbstractArrow newProjectile = (AbstractArrow)new SpectralArrow(level, targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_());
                    newProjectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    stack.m_41774_(1);
                    return (Projectile)newProjectile;
                }
                if (stack.m_150930_(Items.f_42738_)) {
                    Arrow newProjectile = new Arrow(level, targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_());
                    newProjectile.m_36878_(stack);
                    newProjectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    stack.m_41774_(1);
                    return (Projectile)newProjectile;
                }
                if (stack.m_41720_() instanceof ArrowItem) {
                    Arrow newProjectile = new Arrow(level, targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_());
                    newProjectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    stack.m_41774_(1);
                    return (Projectile)newProjectile;
                }
            }
            ShootedItemProjectile newProjectile = new ShootedItemProjectile(level, targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_());
            newProjectile.setStack(stack);
            stack.m_41764_(0);
            return (Projectile)newProjectile;
        }
    }
}

