/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import site.siredvin.turtlematic.api.AutomataCoreTraits;
import site.siredvin.turtlematic.client.RenderTrickOpcode;
import site.siredvin.turtlematic.client.TurtleRenderTrick;
import site.siredvin.turtlematic.client.TurtleRenderTrickRegistry;
import site.siredvin.turtlematic.common.items.base.BaseAutomataCore;
import site.siredvin.turtlematic.util.DataStorageObjects;
import site.siredvin.turtlematic.util.PairMonad;
import site.siredvin.tweakium.modules.peripheral.api.IDataStorage;
import site.siredvin.tweakium.modules.peripheral.util.CompoundTagDataStorage;
import site.siredvin.tweakium.modules.turtle.api.TurtleUpgradeHolder;

public class MixinToolkit {
    public static PairMonad<TurtleRenderTrick, IDataStorage> searchRenderTrickWithData(ITurtleUpgrade upgrade, ITurtleAccess access, TurtleSide side) {
        TurtleRenderTrick coreTrick = TurtleRenderTrickRegistry.INSTANCE.getTrick(upgrade);
        if (coreTrick != null) {
            return new PairMonad<TurtleRenderTrick, CompoundTagDataStorage>(coreTrick, new CompoundTagDataStorage(access.getUpgradeNBTData(side), () -> null));
        }
        if (upgrade instanceof TurtleUpgradeHolder) {
            TurtleUpgradeHolder upgradeHolder = (TurtleUpgradeHolder)upgrade;
            for (UpgradeData internalUpgrade : upgradeHolder.getInternalUpgrades(access, side)) {
                TurtleRenderTrick internalTrick = TurtleRenderTrickRegistry.INSTANCE.getTrick((ITurtleUpgrade)internalUpgrade.upgrade());
                if (internalTrick == null) continue;
                return new PairMonad<TurtleRenderTrick, CompoundTagDataStorage>(internalTrick, new CompoundTagDataStorage(internalUpgrade.data(), () -> null));
            }
        }
        return null;
    }

    public static <T> T traverseUpgrades(ITurtleAccess access, Function<UpgradeData<ITurtleUpgrade>, T> consumer) {
        T subResult;
        TurtleUpgradeHolder upgradeHolder;
        Object object;
        T result;
        UpgradeData leftUpgrade = access.getUpgradeWithData(TurtleSide.LEFT);
        UpgradeData rightUpgrade = access.getUpgradeWithData(TurtleSide.RIGHT);
        if (leftUpgrade != null) {
            result = consumer.apply((UpgradeData<ITurtleUpgrade>)leftUpgrade);
            if (result != null) {
                return result;
            }
            object = leftUpgrade.upgrade();
            if (object instanceof TurtleUpgradeHolder) {
                upgradeHolder = (TurtleUpgradeHolder)object;
                for (UpgradeData subUpgrade : upgradeHolder.getInternalUpgrades(access, TurtleSide.LEFT)) {
                    subResult = consumer.apply((UpgradeData<ITurtleUpgrade>)subUpgrade);
                    if (subResult == null) continue;
                    return subResult;
                }
            }
        }
        if (rightUpgrade != null) {
            result = consumer.apply((UpgradeData<ITurtleUpgrade>)rightUpgrade);
            if (result != null) {
                return result;
            }
            object = rightUpgrade.upgrade();
            if (object instanceof TurtleUpgradeHolder) {
                upgradeHolder = (TurtleUpgradeHolder)object;
                for (UpgradeData subUpgrade : upgradeHolder.getInternalUpgrades(access, TurtleSide.RIGHT)) {
                    subResult = consumer.apply((UpgradeData<ITurtleUpgrade>)subUpgrade);
                    if (subResult == null) continue;
                    return subResult;
                }
            }
        }
        return null;
    }

    public static Integer getColor(ITurtleAccess access) {
        Function<UpgradeData, Integer> func = upgrade -> (Integer)DataStorageObjects.TurtleColor.INSTANCE.get(upgrade.data());
        return MixinToolkit.traverseUpgrades(access, func);
    }

    public static void render(TurtleBlockEntity turtle, float partialTicks, PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight, CallbackInfo info) {
        PairMonad<TurtleRenderTrick, IDataStorage> rightRenderTrick;
        RenderTrickOpcode opcode;
        PairMonad<TurtleRenderTrick, IDataStorage> leftRenderTrick;
        ITurtleUpgrade leftUpgrade = turtle.getUpgrade(TurtleSide.LEFT);
        ITurtleUpgrade rightUpgrade = turtle.getUpgrade(TurtleSide.RIGHT);
        ITurtleAccess access = turtle.getAccess();
        boolean cancelTurtleRender = false;
        if (leftUpgrade != null && (leftRenderTrick = MixinToolkit.searchRenderTrickWithData(leftUpgrade, access, TurtleSide.LEFT)) != null && (opcode = leftRenderTrick.first().render(turtle, access, TurtleSide.LEFT, leftRenderTrick.second(), partialTicks, transform, buffers, lightmapCoord, overlayLight)) == RenderTrickOpcode.CANCEL_RENDER) {
            cancelTurtleRender = true;
        }
        if (rightUpgrade != null && (rightRenderTrick = MixinToolkit.searchRenderTrickWithData(rightUpgrade, access, TurtleSide.RIGHT)) != null && (opcode = rightRenderTrick.first().render(turtle, access, TurtleSide.RIGHT, rightRenderTrick.second(), partialTicks, transform, buffers, lightmapCoord, overlayLight)) == RenderTrickOpcode.CANCEL_RENDER) {
            cancelTurtleRender = true;
        }
        if (cancelTurtleRender) {
            info.cancel();
        }
    }

    public static void isFuelNeeded(ITurtleAccess access, Map<TurtleSide, ITurtleUpgrade> upgrades, CallbackInfoReturnable<Boolean> cir) {
        boolean isFuelConsumptionDisabled;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (isFuelConsumptionDisabled = upgrades.entrySet().stream().anyMatch(it -> {
            Item item;
            if (it.getValue() instanceof TurtleUpgradeHolder) {
                for (UpgradeData internalUpgrade : ((TurtleUpgradeHolder)it.getValue()).getInternalUpgrades(access, (TurtleSide)it.getKey())) {
                    BaseAutomataCore core;
                    Item item2 = internalUpgrade.getUpgradeItem().m_41720_();
                    if (!(item2 instanceof BaseAutomataCore) || !(core = (BaseAutomataCore)item2).getCoreTier().getTraits().contains(AutomataCoreTraits.INSTANCE.getFUEL_CONSUMPTION_DISABLED())) continue;
                    return true;
                }
            }
            if ((item = ((ITurtleUpgrade)it.getValue()).getCraftingItem().m_41720_()) instanceof BaseAutomataCore) {
                BaseAutomataCore core = (BaseAutomataCore)item;
                return core.getCoreTier().getTraits().contains(AutomataCoreTraits.INSTANCE.getFUEL_CONSUMPTION_DISABLED());
            }
            return false;
        }))) {
            cir.setReturnValue((Object)false);
        }
    }
}

