/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.platform.PlatformToolkit;
import site.siredvin.broccolium.modules.platform.api.InnerPlatformToolkit;
import site.siredvin.turtlematic.TurtlematicCore;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0013\u0010\fJ\u0015\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0017\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\"0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0018\u0010(\u001a\u0004\u0018\u00010'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager;", "Lnet/minecraft/class_18;", "<init>", "()V", "Lnet/minecraft/class_3218;", "level", "Ljava/util/UUID;", "owner", "Lnet/minecraft/class_1923;", "pos", "", "addForceChunk", "(Lnet/minecraft/class_3218;Ljava/util/UUID;Lnet/minecraft/class_1923;)Z", "", "touch", "(Ljava/util/UUID;)V", "removeChunk", "(Ljava/util/UUID;Lnet/minecraft/class_1923;Lnet/minecraft/class_3218;)Z", "loadedChunk", "removeForceChunk", "Lnet/minecraft/server/MinecraftServer;", "server", "init", "(Lnet/minecraft/server/MinecraftServer;)V", "stop", "tick", "Lnet/minecraft/class_2487;", "compoundTag", "save", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "", "tickCounter", "J", "", "Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "forcedChunks", "Ljava/util/Map;", "initialized", "Z", "Ljava/lang/Thread;", "mainThread", "Ljava/lang/Thread;", "Companion", "LoadChunkRecord", "turtlematic-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nChunkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkManager.kt\nsite/siredvin/turtlematic/util/ChunkManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1863#2:196\n1864#2:199\n1863#2:200\n1863#2,2:201\n1864#2:203\n1863#2:204\n1611#2,9:205\n1863#2:214\n1864#2:216\n1620#2:217\n1863#2,2:218\n1864#2:220\n216#3,2:197\n216#3,2:221\n1#4:215\n*S KotlinDebug\n*F\n+ 1 ChunkManager.kt\nsite/siredvin/turtlematic/util/ChunkManager\n*L\n108#1:196\n108#1:199\n123#1:200\n125#1:201,2\n123#1:203\n140#1:204\n142#1:205,9\n142#1:214\n142#1:216\n142#1:217\n148#1:218,2\n140#1:220\n110#1:197,2\n158#1:221,2\n142#1:215\n*E\n"})
public final class ChunkManager
extends class_18 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long tickCounter;
    @NotNull
    private final Map<UUID, LoadChunkRecord> forcedChunks = new LinkedHashMap();
    private boolean initialized;
    @Nullable
    private Thread mainThread;
    @NotNull
    private static final String DIMENSION_NAME_TAG = "dimensionName";
    @NotNull
    private static final String POS_TAG = "pos";
    @NotNull
    private static final String DATA_NAME = "turtlematic_ForcedChunks";
    @NotNull
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";

    public final synchronized boolean addForceChunk(@NotNull class_3218 level, @NotNull UUID owner, @NotNull class_1923 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pos, (String)POS_TAG);
        if (this.forcedChunks.containsKey(owner)) {
            TurtlematicCore.INSTANCE.getLogger().debug("Chunk re-added to force loaded {} with touch", (Object)pos);
            LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
            if (loadChunkRecord != null) {
                loadChunkRecord.touch();
            }
            return true;
        }
        TurtlematicCore.INSTANCE.getLogger().debug("Chunk added to force loaded {}", (Object)pos);
        Map<UUID, LoadChunkRecord> map = this.forcedChunks;
        String string = level.method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        LoadChunkRecord loadChunkRecord = new LoadChunkRecord(string, pos, 0L, 4, null);
        map.put(owner, loadChunkRecord);
        this.method_80();
        return InnerPlatformToolkit.DefaultImpls.setChunkForceLoad$default((InnerPlatformToolkit)PlatformToolkit.INSTANCE.get(), (class_3218)level, (String)"turtlematic", (UUID)owner, (class_1923)pos, (boolean)true, (boolean)false, (int)32, null);
    }

    public final synchronized void touch(@NotNull UUID owner) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
            if (loadChunkRecord == null) break block0;
            loadChunkRecord.touch();
        }
    }

    public final synchronized boolean removeChunk(@NotNull UUID owner, @NotNull class_1923 pos, @NotNull class_3218 level) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pos, (String)POS_TAG);
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.mainThread != null && Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.mainThread)) {
            TurtlematicCore.INSTANCE.getLogger().debug("Chunk removed from to force loaded {}", (Object)pos);
            return InnerPlatformToolkit.DefaultImpls.setChunkForceLoad$default((InnerPlatformToolkit)PlatformToolkit.INSTANCE.get(), (class_3218)level, (String)"turtlematic", (UUID)owner, (class_1923)pos, (boolean)false, (boolean)false, (int)32, null);
        }
        TurtlematicCore.INSTANCE.getLogger().debug("Market chunk to remove {}", (Object)pos);
        LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
        if (loadChunkRecord == null) {
            return false;
        }
        LoadChunkRecord forcedChunk = loadChunkRecord;
        forcedChunk.invalidate();
        return false;
    }

    public final synchronized boolean removeForceChunk(@NotNull class_3218 level, @NotNull UUID owner, @Nullable class_1923 loadedChunk) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!this.forcedChunks.containsKey(owner)) {
            return true;
        }
        LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
        if (loadChunkRecord == null) {
            return true;
        }
        LoadChunkRecord chunkRecord = loadChunkRecord;
        String string = level.method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String dimensionName = string;
        if (!Intrinsics.areEqual((Object)chunkRecord.getDimensionName(), (Object)dimensionName)) {
            boolean bl = false;
            Object[] objectArray = new Object[]{chunkRecord.getDimensionName(), dimensionName};
            String string2 = String.format("Incorrect dimension! Should be %s instead of %s", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        boolean bl = result = loadedChunk == null ? this.removeChunk(owner, chunkRecord.getPos(), level) : this.removeChunk(owner, loadedChunk, level);
        if (result) {
            this.forcedChunks.remove(owner);
            this.method_80();
        }
        return result;
    }

    public static /* synthetic */ boolean removeForceChunk$default(ChunkManager chunkManager, class_3218 class_32182, UUID uUID, class_1923 class_19232, int n, Object object) {
        if ((n & 4) != 0) {
            class_19232 = null;
        }
        return chunkManager.removeForceChunk(class_32182, uUID, class_19232);
    }

    public final synchronized void init(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!this.initialized) {
            this.mainThread = server.method_3777();
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"toString(...)");
                Map<UUID, LoadChunkRecord> $this$forEach$iv2 = this.forcedChunks;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    String dimensionName;
                    Map.Entry<UUID, LoadChunkRecord> element$iv2;
                    Map.Entry<UUID, LoadChunkRecord> it = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getValue().getDimensionName(), (Object)dimensionName)) continue;
                    InnerPlatformToolkit innerPlatformToolkit = PlatformToolkit.INSTANCE.get();
                    Intrinsics.checkNotNull((Object)level);
                    InnerPlatformToolkit.DefaultImpls.setChunkForceLoad$default((InnerPlatformToolkit)innerPlatformToolkit, (class_3218)level, (String)"turtlematic", (UUID)it.getKey(), (class_1923)it.getValue().getPos(), (boolean)true, (boolean)false, (int)32, null);
                }
            }
            this.initialized = true;
        }
    }

    public final synchronized void stop(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (this.initialized) {
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"toString(...)");
                Iterable $this$forEach$iv2 = this.forcedChunks.entrySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dimensionName;
                    Map.Entry it = (Map.Entry)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((LoadChunkRecord)it.getValue()).getDimensionName(), (Object)dimensionName)) continue;
                    InnerPlatformToolkit innerPlatformToolkit = PlatformToolkit.INSTANCE.get();
                    Intrinsics.checkNotNull((Object)level);
                    InnerPlatformToolkit.DefaultImpls.setChunkForceLoad$default((InnerPlatformToolkit)innerPlatformToolkit, (class_3218)level, (String)"turtlematic", (UUID)((UUID)it.getKey()), (class_1923)((LoadChunkRecord)it.getValue()).getPos(), (boolean)false, (boolean)false, (int)32, null);
                }
            }
            this.initialized = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void tick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        long l = this.tickCounter;
        this.tickCounter = l + 1L;
        if (this.tickCounter % (long)20 == 0L) {
            Iterable iterable = server.method_3738();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapNotNullTo$iv$iv;
                class_3218 level = (class_3218)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"toString(...)");
                Iterable $this$mapNotNull$iv = this.forcedChunks.entrySet();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    UUID it$iv$iv;
                    String dimensionName;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl3 = false;
                    if ((Intrinsics.areEqual((Object)((LoadChunkRecord)it.getValue()).getDimensionName(), (Object)dimensionName) && !((LoadChunkRecord)it.getValue()).getValid() ? (UUID)it.getKey() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List purgeList = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = purgeList;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    UUID it = (UUID)element$iv2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)level);
                    ChunkManager.removeForceChunk$default(this, level, it, null, 4, null);
                }
            }
        }
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        TurtlematicCore.INSTANCE.getLogger().info("Saving all forces chunks " + this.forcedChunks.entrySet().size());
        class_2487 forcedChunksTag = new class_2487();
        Map<UUID, LoadChunkRecord> $this$forEach$iv = this.forcedChunks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LoadChunkRecord> element$iv;
            Map.Entry<UUID, LoadChunkRecord> entry = element$iv = iterator.next();
            boolean bl = false;
            UUID key = entry.getKey();
            LoadChunkRecord value = entry.getValue();
            forcedChunksTag.method_10566(key.toString(), (class_2520)value.serialize());
        }
        compoundTag.method_10566(FORCED_CHUNKS_TAG, (class_2520)forcedChunksTag);
        return compoundTag;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2487;", "tag", "Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "readChunkRecord", "(Lnet/minecraft/class_2487;)Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "data", "Lsite/siredvin/turtlematic/util/ChunkManager;", "load", "(Lnet/minecraft/class_2487;)Lsite/siredvin/turtlematic/util/ChunkManager;", "Lnet/minecraft/class_3218;", "level", "get", "(Lnet/minecraft/class_3218;)Lsite/siredvin/turtlematic/util/ChunkManager;", "", "DIMENSION_NAME_TAG", "Ljava/lang/String;", "POS_TAG", "DATA_NAME", "FORCED_CHUNKS_TAG", "turtlematic-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        private final LoadChunkRecord readChunkRecord(class_2487 tag) {
            String string = tag.method_10558(ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            class_2487 class_24872 = tag.method_10562(ChunkManager.POS_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
            return new LoadChunkRecord(string, UtilsKt.chunkPosFromNBT(class_24872), 0L, 4, null);
        }

        @NotNull
        public final ChunkManager load(@NotNull class_2487 data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ChunkManager manager = new ChunkManager();
            class_2487 forcedData = data.method_10562(ChunkManager.FORCED_CHUNKS_TAG);
            for (String key : forcedData.method_10541()) {
                Map map = manager.forcedChunks;
                UUID uUID = UUID.fromString(key);
                class_2487 class_24872 = forcedData.method_10562(key);
                Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"getCompound(...)");
                LoadChunkRecord loadChunkRecord = this.readChunkRecord(class_24872);
                map.put(uUID, loadChunkRecord);
            }
            TurtlematicCore.INSTANCE.getLogger().info("Loaded " + manager.forcedChunks.size() + " forced chunks");
            return manager;
        }

        @NotNull
        public final ChunkManager get(@NotNull class_3218 level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            class_18 class_182 = level.method_17983().method_17924(Companion::load, Companion::get$lambda$0, ChunkManager.DATA_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)class_182, (String)"computeIfAbsent(...)");
            return (ChunkManager)class_182;
        }

        private static final ChunkManager get$lambda$0() {
            return new ChunkManager();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J.\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b \u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0014R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010(R\u0011\u0010+\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "", "", "dimensionName", "Lnet/minecraft/class_1923;", "pos", "", "lastTouch", "<init>", "(Ljava/lang/String;Lnet/minecraft/class_1923;J)V", "", "touch", "()V", "invalidate", "Lnet/minecraft/class_2487;", "serialize", "()Lnet/minecraft/class_2487;", "component1", "()Ljava/lang/String;", "component2", "()Lnet/minecraft/class_1923;", "component3", "()J", "copy", "(Ljava/lang/String;Lnet/minecraft/class_1923;J)Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getDimensionName", "Lnet/minecraft/class_1923;", "getPos", "J", "getLastTouch", "setLastTouch", "(J)V", "getValid", "()Z", "valid", "turtlematic-fabric-1.20.1"})
    public static final class LoadChunkRecord {
        @NotNull
        private final String dimensionName;
        @NotNull
        private final class_1923 pos;
        private long lastTouch;

        public LoadChunkRecord(@NotNull String dimensionName, @NotNull class_1923 pos, long lastTouch) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullParameter((Object)pos, (String)ChunkManager.POS_TAG);
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.lastTouch = lastTouch;
        }

        public /* synthetic */ LoadChunkRecord(String string, class_1923 class_19232, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = Instant.now().getEpochSecond();
            }
            this(string, class_19232, l);
        }

        @NotNull
        public final String getDimensionName() {
            return this.dimensionName;
        }

        @NotNull
        public final class_1923 getPos() {
            return this.pos;
        }

        public final long getLastTouch() {
            return this.lastTouch;
        }

        public final void setLastTouch(long l) {
            this.lastTouch = l;
        }

        public final boolean getValid() {
            long currentEpoch = Instant.now().getEpochSecond();
            return this.lastTouch + TurtlematicConfig.INSTANCE.getChunkLoadedTimeLimit() >= currentEpoch;
        }

        public final void touch() {
            this.lastTouch = Instant.now().getEpochSecond();
        }

        public final void invalidate() {
            this.lastTouch = Instant.now().getEpochSecond() - TurtlematicConfig.INSTANCE.getChunkLoadedTimeLimit() / (long)2;
        }

        @NotNull
        public final class_2487 serialize() {
            class_2487 tag = new class_2487();
            tag.method_10582(ChunkManager.DIMENSION_NAME_TAG, this.dimensionName);
            tag.method_10566(ChunkManager.POS_TAG, (class_2520)UtilsKt.toNBT(this.pos));
            return tag;
        }

        @NotNull
        public final String component1() {
            return this.dimensionName;
        }

        @NotNull
        public final class_1923 component2() {
            return this.pos;
        }

        public final long component3() {
            return this.lastTouch;
        }

        @NotNull
        public final LoadChunkRecord copy(@NotNull String dimensionName, @NotNull class_1923 pos, long lastTouch) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullParameter((Object)pos, (String)ChunkManager.POS_TAG);
            return new LoadChunkRecord(dimensionName, pos, lastTouch);
        }

        public static /* synthetic */ LoadChunkRecord copy$default(LoadChunkRecord loadChunkRecord, String string, class_1923 class_19232, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = loadChunkRecord.dimensionName;
            }
            if ((n & 2) != 0) {
                class_19232 = loadChunkRecord.pos;
            }
            if ((n & 4) != 0) {
                l = loadChunkRecord.lastTouch;
            }
            return loadChunkRecord.copy(string, class_19232, l);
        }

        @NotNull
        public String toString() {
            return "LoadChunkRecord(dimensionName=" + this.dimensionName + ", pos=" + this.pos + ", lastTouch=" + this.lastTouch + ")";
        }

        public int hashCode() {
            int result = this.dimensionName.hashCode();
            result = result * 31 + this.pos.hashCode();
            result = result * 31 + Long.hashCode(this.lastTouch);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoadChunkRecord)) {
                return false;
            }
            LoadChunkRecord loadChunkRecord = (LoadChunkRecord)other;
            if (!Intrinsics.areEqual((Object)this.dimensionName, (Object)loadChunkRecord.dimensionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)loadChunkRecord.pos)) {
                return false;
            }
            return this.lastTouch == loadChunkRecord.lastTouch;
        }
    }
}

