/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.automatas;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.storage.item.ContainerUtils;
import site.siredvin.turtlematic.api.AutomataCoreTraits;
import site.siredvin.turtlematic.api.IAutomataCoreTier;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.operations.SphereOperation;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.plugins.AutomataAIPlugin;
import site.siredvin.turtlematic.computercraft.plugins.AutomataCapturePlugin;
import site.siredvin.turtlematic.computercraft.plugins.AutomataInteractionPlugin;
import site.siredvin.turtlematic.computercraft.plugins.AutomataItemSuckPlugin;
import site.siredvin.turtlematic.computercraft.plugins.AutomataLookPlugin;
import site.siredvin.turtlematic.tags.BlockTags;
import site.siredvin.turtlematic.tags.EntityTags;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralFunction;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoon;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.api.InteractionMode;
import site.siredvin.tweakium.modules.peripheral.api.VerticalDirection;
import site.siredvin.tweakium.modules.peripheral.boon.PeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.boon.ScanningBoon;
import site.siredvin.tweakium.modules.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.EnrichersKt;
import site.siredvin.tweakium.modules.player.FakePlayerProxy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/HusbandryAutomataCorePeripheral;", "Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/BaseAutomataCorePeripheral;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "tier", "Lsite/siredvin/turtlematic/api/IAutomataCoreTier;", "<init>", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/turtlematic/api/IAutomataCoreTier;)V", "isEnabled", "", "()Z", "maxHusbandryPoints", "", "getMaxHusbandryPoints", "()I", "possibleOperations", "", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOperation;", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "getHusbandryPoints", "simulateGrow", "Ldan200/computercraft/api/lua/MethodResult;", "harvest", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "Companion", "turtlematic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHusbandryAutomataCorePeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HusbandryAutomataCorePeripheral.kt\nsite/siredvin/turtlematic/computercraft/peripheral/automatas/HusbandryAutomataCorePeripheral\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n1#2:205\n1863#3,2:206\n*S KotlinDebug\n*F\n+ 1 HusbandryAutomataCorePeripheral.kt\nsite/siredvin/turtlematic/computercraft/peripheral/automatas/HusbandryAutomataCorePeripheral\n*L\n187#1:206,2\n*E\n"})
public final class HusbandryAutomataCorePeripheral
extends BaseAutomataCorePeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String type = "husbandryAutomata";
    @NotNull
    private static final Predicate<Entity> isAnimal = HusbandryAutomataCorePeripheral::isAnimal$lambda$10;
    @NotNull
    private static final Predicate<Entity> isLivingEntity = HusbandryAutomataCorePeripheral::isLivingEntity$lambda$11;
    @NotNull
    private static final Predicate<Entity> isNotPlayer = HusbandryAutomataCorePeripheral::isNotPlayer$lambda$12;
    private static final Predicate<Entity> suitableEntity = isAnimal.and(isLivingEntity).and(isNotPlayer);
    @NotNull
    private static final String HUSBANDRY_POINTS = "husbandryPoints";
    private static final int BASE_MAX_HUSBANDRY_POINTS = 10000;
    private static final int HUSBANDRY_SIMULATE_COST = 100;
    private static final int MAGIC_AMOUNT_OF_TREE_LOG_OUTPUT = 12;

    public HusbandryAutomataCorePeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side, @NotNull IAutomataCoreTier tier) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        super(type, turtle, side, tier);
        Object object = new BiConsumer[]{EnrichersKt.getCropAge(), EnrichersKt.getHoneyLevel()};
        this.addPlugin(new AutomataLookPlugin(this, CollectionsKt.listOf((Object)EnrichersKt.getAnimalData()), CollectionsKt.listOf((Object[])object), CollectionsKt.listOf((Object)EnrichersKt.getBeeNestAnalyze()), null, 16, null));
        object = ArraysKt.toSet((Object[])InteractionMode.values());
        Predicate<Entity> predicate = suitableEntity;
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"suitableEntity");
        Predicate<Entity> predicate2 = predicate;
        this.addPlugin(new AutomataInteractionPlugin(this, predicate2, (Set<? extends InteractionMode>)object));
        this.addPlugin(new AutomataItemSuckPlugin(this));
        object = new BiConsumer[]{HusbandryAutomataCorePeripheral::_init_$lambda$1};
        ((TurtlePeripheralOwner)this.getPeripheralOwner()).attachBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getSCANNING(), (IPeripheralOwnerBoon)new ScanningBoon(this.getPeripheralOwner(), tier.getInteractionRadius()).attachItemScan((IPeripheralOperation)SphereOperation.SCAN_ITEMS, new BiConsumer[0]).attachLivingEntityScan((IPeripheralOperation)SphereOperation.SCAN_ENTITIES, HusbandryAutomataCorePeripheral::_init_$lambda$0, (BiConsumer[])object));
        BaseAutomataCorePeripheral baseAutomataCorePeripheral = this;
        Set set = SetsKt.setOf((Object)InteractionMode.ENTITY);
        Predicate<Entity> predicate3 = suitableEntity;
        Intrinsics.checkNotNullExpressionValue(predicate3, (String)"suitableEntity");
        this.addPlugin(new AutomataCapturePlugin(baseAutomataCorePeripheral, set, predicate3));
        if (tier.getTraits().contains(AutomataCoreTraits.INSTANCE.getAPPRENTICE())) {
            BaseAutomataCorePeripheral baseAutomataCorePeripheral2 = this;
            Predicate<Object> predicate4 = suitableEntity.and(arg_0 -> HusbandryAutomataCorePeripheral._init_$lambda$3(HusbandryAutomataCorePeripheral::_init_$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue(predicate4, (String)"and(...)");
            this.addPlugin(new AutomataAIPlugin(baseAutomataCorePeripheral2, predicate4));
        }
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableHusbandryAutomataCore();
    }

    public final int getMaxHusbandryPoints() {
        return 10000 * this.getTier().getInteractionRadius() / 2;
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> possibleOperations() {
        List<IPeripheralOperation<?>> base = super.possibleOperations();
        base.add(SingleOperation.HARVEST);
        return base;
    }

    @Override
    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map<String, Object> base = super.getPeripheralConfiguration();
        base.put("maxHusbandryPoints", this.getMaxHusbandryPoints());
        base.put("simulationGrowCost", 100);
        return base;
    }

    @LuaFunction(mainThread=true)
    public final int getHusbandryPoints() {
        return ((TurtlePeripheralOwner)this.getPeripheralOwner()).getDataStorage().getInt(HUSBANDRY_POINTS);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult simulateGrow() {
        ItemStack selectedItem = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getToolInMainHand();
        int points = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getDataStorage().getInt(HUSBANDRY_POINTS);
        if (points <= 100) {
            Object[] objectArray = new Object[]{false, "Not enough points"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (selectedItem.m_41720_() instanceof BlockItem) {
            Item item = selectedItem.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof SaplingBlock) {
                ConfiguredFeature configuredFeature;
                AbstractTreeGrower abstractTreeGrower = ((SaplingBlock)block).f_55975_;
                Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
                Intrinsics.checkNotNull((Object)level);
                ResourceKey resourceKey = abstractTreeGrower.m_213888_(level.f_46441_, false);
                if (resourceKey == null) {
                    Object[] objectArray = new Object[]{false, "Item is incorrect for simulation grow"};
                    MethodResult methodResult = MethodResult.of((Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                    return methodResult;
                }
                ResourceKey treeFeatureKey = resourceKey;
                Level level2 = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
                Intrinsics.checkNotNull((Object)level2);
                Optional optional = level2.m_9598_().m_175515_(Registries.f_256911_).m_203636_(treeFeatureKey);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getHolder(...)");
                Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
                if (reference == null || (configuredFeature = (ConfiguredFeature)reference.m_203334_()) == null) {
                    Object[] objectArray = new Object[]{false, "Item is incorrect for simulation grow"};
                    MethodResult methodResult = MethodResult.of((Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                    return methodResult;
                }
                ConfiguredFeature treeFeature = configuredFeature;
                FeatureConfiguration featureConfiguration = treeFeature.f_65378_();
                TreeConfiguration treeConfiguration = featureConfiguration instanceof TreeConfiguration ? (TreeConfiguration)featureConfiguration : null;
                if (treeConfiguration == null) {
                    Object[] objectArray = new Object[]{false, "Item is incorrect for simulation grow"};
                    MethodResult methodResult = MethodResult.of((Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                    return methodResult;
                }
                TreeConfiguration configuration = treeConfiguration;
                BlockStateProvider blockStateProvider = configuration.f_68185_;
                Level level3 = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
                Intrinsics.checkNotNull((Object)level3);
                BlockState truckBlock = blockStateProvider.m_213972_(level3.f_46441_, new BlockPos(0, 0, 0));
                ItemStack itemStack = truckBlock.m_60734_().m_5456_().m_7968_().m_255036_(12);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
                Container container = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getInventory();
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
                int n = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getSelectedSlot();
                BlockPos blockPos = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getPos().m_7494_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
                Level level4 = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
                Intrinsics.checkNotNull((Object)level4);
                ContainerUtils.INSTANCE.toInventoryOrToWorld(itemStack, container, n, blockPos, level4);
                ((TurtlePeripheralOwner)this.getPeripheralOwner()).getDataStorage().putInt(HUSBANDRY_POINTS, RangesKt.coerceAtLeast((int)(((TurtlePeripheralOwner)this.getPeripheralOwner()).getDataStorage().getInt(HUSBANDRY_POINTS) - 100), (int)0));
                MethodResult methodResult = MethodResult.of((Object)true);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                return methodResult;
            }
        }
        Object[] objectArray = new Object[]{false, "Item is incorrect for simulation grow"};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult harvest(@NotNull IArguments arguments) {
        Object v6;
        Object[] objectArray;
        Object object;
        BlockState blockState;
        Level level;
        HitResult result;
        VerticalDirection overwrittenDirection;
        block9: {
            VerticalDirection verticalDirection;
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Optional directionArgument = arguments.optString(0);
            if (directionArgument.isEmpty()) {
                verticalDirection = null;
            } else {
                Object t = directionArgument.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                verticalDirection = VerticalDirection.Companion.luaValueOf((String)t);
            }
            overwrittenDirection = verticalDirection;
            VerticalDirection verticalDirection2 = overwrittenDirection;
            result = (HitResult)IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this.getPeripheralOwner(), HusbandryAutomataCorePeripheral::harvest$lambda$4, (Direction)(verticalDirection2 != null ? verticalDirection2.getMinecraftDirection() : null), (boolean)false, (int)4, null);
            if (!(result instanceof BlockHitResult)) {
                Object[] objectArray2 = new Object[]{null, "Nothing to harvest from"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
                return methodResult;
            }
            Level level2 = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level2);
            level = level2;
            blockState = level.m_8055_(((BlockHitResult)result).m_82425_());
            Collection collection = blockState.m_61147_();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProperties(...)");
            object = (Object[])collection;
            objectArray = object.iterator();
            while (objectArray.hasNext()) {
                Object t = objectArray.next();
                Property it = (Property)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.m_61708_(), (Object)"age")) continue;
                v6 = t;
                break block9;
            }
            v6 = null;
        }
        IntegerProperty integerProperty = v6;
        if (integerProperty == null) {
            object = new Object[]{null, "This block is not harvestable"};
            MethodResult methodResult = MethodResult.of((Object[])object);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        IntegerProperty ageProperty = integerProperty;
        if (!(blockState.m_60734_() instanceof CropBlock) && !blockState.m_204336_(BlockTags.INSTANCE.getHUSBANDRY_EXTRA_CROPS())) {
            Object[] objectArray3 = new Object[]{null, "This block is not harvestable"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray3);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Collection collection = ageProperty.m_6908_();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPossibleValues(...)");
        object = ((Iterable)collection).iterator();
        if (!object.hasNext()) {
            throw new NoSuchElementException();
        }
        Integer it = (Integer)object.next();
        boolean bl = false;
        objectArray = it;
        while (object.hasNext()) {
            Integer it2 = (Integer)object.next();
            $i$a$-maxOf-HusbandryAutomataCorePeripheral$harvest$maxAge$1 = false;
            Comparable comparable = it2;
            if (objectArray.compareTo(comparable) >= 0) continue;
            objectArray = comparable;
        }
        Integer maxAge = (Integer)objectArray;
        Integer currentAge = (Integer)blockState.m_61143_((Property)ageProperty);
        if (!Intrinsics.areEqual((Object)currentAge, (Object)maxAge)) {
            objectArray = new Object[]{null, "Too early for harvesting"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        return this.withOperation(SingleOperation.HARVEST, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> HusbandryAutomataCorePeripheral.harvest$lambda$9(this, overwrittenDirection, blockState, level, result, ageProperty, arg_0)));
    }

    private static final boolean _init_$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return suitableEntity.test((Entity)it);
    }

    private static final void _init_$lambda$1(LivingEntity it1, Map it2) {
        Intrinsics.checkNotNullParameter((Object)it1, (String)"it1");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it2");
        EnrichersKt.getAnimalData().accept(it1, it2);
    }

    private static final boolean _init_$lambda$2(Entity it) {
        return !it.m_6095_().m_204039_(EntityTags.INSTANCE.getAI_CONTROL_BLOCKLIST());
    }

    private static final boolean _init_$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final HitResult harvest$lambda$4(FakePlayerProxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.findHit(true, false);
    }

    private static final List harvest$lambda$9$lambda$7(BlockState $blockState, Level $level, HitResult $result, FakePlayerProxy it) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Block.m_49874_((BlockState)$blockState, (ServerLevel)((ServerLevel)$level), (BlockPos)((BlockHitResult)$result).m_82425_(), null, (Entity)((Entity)it.getFakePlayer()), (ItemStack)it.getFakePlayer().m_21205_());
    }

    private static final MethodResult harvest$lambda$9(HusbandryAutomataCorePeripheral this$0, VerticalDirection $overwrittenDirection, BlockState $blockState, Level $level, HitResult $result, IntegerProperty $ageProperty, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$ageProperty, (String)"$ageProperty");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VerticalDirection verticalDirection = $overwrittenDirection;
        List stacks = (List)IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this$0.getPeripheralOwner(), arg_0 -> HusbandryAutomataCorePeripheral.harvest$lambda$9$lambda$7($blockState, $level, $result, arg_0), (Direction)(verticalDirection != null ? verticalDirection.getMinecraftDirection() : null), (boolean)false, (int)4, null);
        Item targetItemToReduce = $blockState.m_60734_().m_5456_();
        $level.m_46597_(((BlockHitResult)$result).m_82425_(), (BlockState)$blockState.m_61124_((Property)$ageProperty, (Comparable)Integer.valueOf(0)));
        Intrinsics.checkNotNull((Object)stacks);
        Iterable $this$forEach$iv = stacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it2 = (ItemStack)element$iv;
            boolean bl = false;
            if (it2.m_150930_(targetItemToReduce)) {
                it2.m_41774_(1);
            }
            ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getDataStorage().putInt(HUSBANDRY_POINTS, RangesKt.coerceAtMost((int)(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getDataStorage().getInt(HUSBANDRY_POINTS) + it2.m_41613_() * this$0.getTier().getInteractionRadius() / 2), (int)this$0.getMaxHusbandryPoints()));
            Intrinsics.checkNotNull((Object)it2);
            Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
            int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
            BlockPos blockPos = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos().m_7494_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
            ContainerUtils.INSTANCE.toInventoryOrToWorld(it2, container, n, blockPos, $level);
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final boolean isAnimal$lambda$10(Entity entity1) {
        Intrinsics.checkNotNullParameter((Object)entity1, (String)"entity1");
        return entity1.m_6095_().m_20674_().m_21609_() || entity1.m_6095_().m_20674_() == MobCategory.CREATURE || entity1.m_6095_().m_204039_(EntityTags.INSTANCE.getANIMAL());
    }

    private static final boolean isLivingEntity$lambda$11(Entity entity1) {
        return entity1 instanceof LivingEntity;
    }

    private static final boolean isNotPlayer$lambda$12(Entity entity1) {
        return !(entity1 instanceof Player);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000e\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/HusbandryAutomataCorePeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "isAnimal", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "()Ljava/util/function/Predicate;", "isLivingEntity", "isNotPlayer", "suitableEntity", "kotlin.jvm.PlatformType", "Ljava/util/function/Predicate;", "HUSBANDRY_POINTS", "BASE_MAX_HUSBANDRY_POINTS", "", "HUSBANDRY_SIMULATE_COST", "MAGIC_AMOUNT_OF_TREE_LOG_OUTPUT", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @NotNull
        public final Predicate<Entity> isAnimal() {
            return isAnimal;
        }

        @Override
        @NotNull
        public ResourceLocation getUpgradeID() {
            return PeripheralConfiguration.DefaultImpls.getUpgradeID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

