/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.forged;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import site.siredvin.broccolium.modules.base.util.ValueContainer;
import site.siredvin.broccolium.modules.base.util.XPUtil;
import site.siredvin.broccolium.modules.base.util.world.ScanUtils;
import site.siredvin.broccolium.modules.storage.item.AgnosticItemStorageLookup;
import site.siredvin.broccolium.modules.storage.item.api.AgnosticItemStorage;
import site.siredvin.turtlematic.api.AutomataCoreTraits;
import site.siredvin.turtlematic.api.IAutomataCoreTier;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.peripheral.forged.ExperienceAutomataCorePeripheral;
import site.siredvin.turtlematic.tags.BlockTags;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralFunction;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.boon.ExperienceBoon;
import site.siredvin.tweakium.modules.peripheral.boon.PeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.LuaRepresentation;
import site.siredvin.tweakium.modules.peripheral.util.ValidationHelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0016J\b\u0010&\u001a\u00020#H\u0007J\b\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020*H\u0007J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020#H\u0007J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020#H\u0007R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R$\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00060"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/EnchantingAutomataCorePeripheral;", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/ExperienceAutomataCorePeripheral;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "tier", "Lsite/siredvin/turtlematic/api/IAutomataCoreTier;", "<init>", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/turtlematic/api/IAutomataCoreTier;)V", "storedEnchantmentSeed", "", "getStoredEnchantmentSeed", "()J", "setStoredEnchantmentSeed", "(J)V", "isEnabled", "", "()Z", "allowTreasureEnchants", "getAllowTreasureEnchants", "value", "enchantmentSeed", "getEnchantmentSeed", "setEnchantmentSeed", "peripheralConfiguration", "", "", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "possibleOperations", "", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOperation;", "enchantmentPower", "", "getEnchantmentPower", "()I", "getEnchantmentPowerLua", "refreshEnchantments", "", "getPossibleEnchantments", "Ldan200/computercraft/api/lua/MethodResult;", "enchant", "luaSlot", "extractEnchantment", "target", "Companion", "turtlematic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nEnchantingAutomataCorePeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantingAutomataCorePeripheral.kt\nsite/siredvin/turtlematic/computercraft/peripheral/forged/EnchantingAutomataCorePeripheral\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,195:1\n13367#2,2:196\n32#3,2:198\n*S KotlinDebug\n*F\n+ 1 EnchantingAutomataCorePeripheral.kt\nsite/siredvin/turtlematic/computercraft/peripheral/forged/EnchantingAutomataCorePeripheral\n*L\n109#1:196,2\n81#1:198,2\n*E\n"})
public class EnchantingAutomataCorePeripheral
extends ExperienceAutomataCorePeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long storedEnchantmentSeed;
    @NotNull
    private static final String type = "enchantingAutomata";
    private static final int MAX_ENCHANTMENT_LEVEL = 30;

    public EnchantingAutomataCorePeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side, @NotNull IAutomataCoreTier tier) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        super(type, turtle, side, tier);
        this.storedEnchantmentSeed = -1L;
    }

    public final long getStoredEnchantmentSeed() {
        return this.storedEnchantmentSeed;
    }

    public final void setStoredEnchantmentSeed(long l) {
        this.storedEnchantmentSeed = l;
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableEnchantingAutomataCore();
    }

    public boolean getAllowTreasureEnchants() {
        return this.getTier().getTraits().contains(AutomataCoreTraits.INSTANCE.getSKILLED());
    }

    public final long getEnchantmentSeed() {
        if (this.storedEnchantmentSeed == -1L) {
            Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level);
            this.storedEnchantmentSeed = level.f_46441_.m_188505_();
        }
        return this.storedEnchantmentSeed;
    }

    public final void setEnchantmentSeed(long value) {
        this.storedEnchantmentSeed = value;
    }

    @Override
    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map<String, Object> data = super.getPeripheralConfiguration();
        data.put("treasureEnchantmentsAllowed", this.getAllowTreasureEnchants());
        data.put("enchantmentWipeChance", TurtlematicConfig.INSTANCE.getEnchantmentWipeChance());
        return data;
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> possibleOperations() {
        List<IPeripheralOperation<?>> base = super.possibleOperations();
        base.add(SingleOperation.ENCHANTMENT);
        return base;
    }

    private final int getEnchantmentPower() {
        ValueContainer enchantmentPower = new ValueContainer((Object)0);
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        ScanUtils.traverseBlocks$default((ScanUtils)ScanUtils.INSTANCE, (Level)level2, (BlockPos)((TurtlePeripheralOwner)this.getPeripheralOwner()).getPos(), (int)2, (arg_0, arg_1) -> EnchantingAutomataCorePeripheral._get_enchantmentPower_$lambda$1(enchantmentPower, level2, arg_0, arg_1), (boolean)false, null, (int)48, null);
        return Math.max(((Number)enchantmentPower.getValue()).intValue() * 2, 30);
    }

    @LuaFunction(value={"getEnchantmentPower"}, mainThread=true)
    public final int getEnchantmentPowerLua() {
        return this.getEnchantmentPower();
    }

    @LuaFunction(mainThread=true)
    public final void refreshEnchantments() {
        long l = this.getEnchantmentSeed();
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        this.setEnchantmentSeed(l + level.f_46441_.m_188505_());
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getPossibleEnchantments() {
        int selectedSlot = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getSelectedSlot();
        Container container = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack targetItem = itemStack;
        if (!targetItem.m_41792_()) {
            Object[] objectArray = new Object[]{null, "Item is not enchantable"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (targetItem.m_41793_()) {
            Object[] objectArray = new Object[]{null, "Item already enchanted!"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        List possibleEnchantments = new ArrayList();
        ExperienceBoon experienceBoon = (ExperienceBoon)((TurtlePeripheralOwner)this.getPeripheralOwner()).getBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getEXPERIENCE());
        if (experienceBoon == null) {
            Object[] objectArray = new Object[]{null, "Internal error ...?"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ExperienceBoon experienceAbility = experienceBoon;
        int[] nArray = new int[]{0, 1, 2};
        int[] $this$forEach$iv = nArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            int cost = EnchantmentHelper.m_220287_((RandomSource)RandomSource.m_216335_((long)(this.getEnchantmentSeed() + (long)it)), (int)it, (int)this.getEnchantmentPower(), (ItemStack)targetItem);
            List enchantments = EnchantmentHelper.m_220297_((RandomSource)RandomSource.m_216335_((long)(this.getEnchantmentSeed() + (long)it)), (ItemStack)targetItem, (int)cost, (boolean)this.getAllowTreasureEnchants());
            Intrinsics.checkNotNull((Object)enchantments);
            if (!(!((Collection)enchantments).isEmpty())) continue;
            EnchantmentInstance enchantment = (EnchantmentInstance)CollectionsKt.first((List)enchantments);
            Enchantment enchantment2 = enchantment.f_44947_;
            Intrinsics.checkNotNullExpressionValue((Object)enchantment2, (String)"enchantment");
            Map baseInformation = LuaRepresentation.INSTANCE.forEnchantment(enchantment2, enchantment.f_44948_);
            double requiredCost = XPUtil.INSTANCE.levelsToXP(cost);
            Double d = requiredCost;
            baseInformation.put("requiredXP", d);
            baseInformation.put("cost", XPUtil.INSTANCE.levelReductionToXp(RangesKt.coerceAtLeast((double)experienceAbility.getStoredXP(), (double)requiredCost), it + 1));
            possibleEnchantments.add(baseInformation);
        }
        MethodResult methodResult = MethodResult.of((Object)possibleEnchantments);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult enchant(int luaSlot) throws LuaException {
        ValidationHelpersKt.assertBetween((int)luaSlot, (int)1, (int)3, (String)"selected");
        int slot = luaSlot - 1;
        return this.withOperation(SingleOperation.ENCHANTMENT, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> EnchantingAutomataCorePeripheral.enchant$lambda$3(this, luaSlot, slot, arg_0)));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult extractEnchantment(int target) throws LuaException {
        ValidationHelpersKt.isCorrectSlot((int)target);
        int realSlot = target - 1;
        return this.withOperation(SingleOperation.ENCHANTMENT, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> EnchantingAutomataCorePeripheral.extractEnchantment$lambda$5(this, realSlot, arg_0)));
    }

    private static final void _get_enchantmentPower_$lambda$1(ValueContainer $enchantmentPower, Level $level, BlockState blockState, BlockPos blockPos) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$enchantmentPower, (String)"$enchantmentPower");
                Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
                Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
                Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
                if (!blockState.m_204336_(BlockTags.INSTANCE.getENCHANTMENT_POWER_PROVIDER())) break block2;
                $enchantmentPower.setValue((Object)(((Number)$enchantmentPower.getValue()).intValue() + 1));
                break block3;
            }
            if (!blockState.m_204336_(ComputerCraftTags.Blocks.TURTLE)) break block3;
            AgnosticItemStorage itemStorage = AgnosticItemStorageLookup.INSTANCE.extractStorage($level, blockPos, $level.m_7702_(blockPos));
            Object object = itemStorage;
            if (object != null && (object = object.getItems()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Object object2 = $this$forEach$iv;
                while (object2.hasNext()) {
                    Object element$iv = object2.next();
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    if (!it.m_150930_(Items.f_42690_)) continue;
                    $enchantmentPower.setValue((Object)(((Number)$enchantmentPower.getValue()).intValue() + 1));
                }
            }
        }
    }

    private static final MethodResult enchant$lambda$3(EnchantingAutomataCorePeripheral this$0, int $luaSlot, int $slot, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExperienceBoon experienceBoon = (ExperienceBoon)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getEXPERIENCE());
        if (experienceBoon == null) {
            Object[] objectArray = new Object[]{null, "Internal error ...?"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ExperienceBoon experienceAbility = experienceBoon;
        BaseAutomataCorePeripheral.addRotationCycle$default(this$0, 0, 1, null);
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack targetItem = itemStack;
        if (!targetItem.m_41792_()) {
            Object[] objectArray = new Object[]{null, "Item is not enchantable"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (targetItem.m_41793_()) {
            Object[] objectArray = new Object[]{null, "Item already enchanted!"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        double requiredXP = XPUtil.INSTANCE.levelReductionToXp(experienceAbility.getStoredXP(), $luaSlot);
        if (requiredXP > experienceAbility.getStoredXP()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            String string = "Not enough XP, %d required";
            Object[] objectArray2 = new Object[]{requiredXP};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        ItemStack itemStack2 = EnchantmentHelper.m_220292_((RandomSource)RandomSource.m_216335_((long)(this$0.getEnchantmentSeed() + (long)$slot)), (ItemStack)targetItem, (int)this$0.getEnchantmentPower(), (boolean)this$0.getAllowTreasureEnchants());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"enchantItem(...)");
        ItemStack enchantedItem = itemStack2;
        experienceAbility.adjustStoredXP(-requiredXP);
        turtleInventory.m_6836_(selectedSlot, enchantedItem);
        this$0.refreshEnchantments();
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final void extractEnchantment$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final MethodResult extractEnchantment$lambda$5(EnchantingAutomataCorePeripheral this$0, int $realSlot, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack selectedItem = itemStack;
        ItemStack itemStack2 = turtleInventory.m_8020_($realSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItem(...)");
        ItemStack targetItem = itemStack2;
        if (!selectedItem.m_41793_()) {
            Object[] objectArray = new Object[]{null, "Selected item is not enchanted"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (!targetItem.m_41720_().equals((Object)Items.f_42517_)) {
            Object[] objectArray = new Object[]{null, "Target item is not book"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        if (targetItem.m_41613_() != 1) {
            Object[] objectArray = new Object[]{null, "Target book should be 1 in stack"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Map map = EnchantmentHelper.m_44831_((ItemStack)selectedItem);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantments(...)");
        Map enchants = map;
        if (!this$0.getTier().getTraits().contains(AutomataCoreTraits.INSTANCE.getSKILLED())) {
            Level level = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getLevel();
            Intrinsics.checkNotNull((Object)level);
            if ((double)level.f_46441_.m_188503_(100) < TurtlematicConfig.INSTANCE.getEnchantmentWipeChance() * (double)100) {
                enchants.keySet().stream().findAny().ifPresent(arg_0 -> EnchantingAutomataCorePeripheral.extractEnchantment$lambda$5$lambda$4((Function1)new Function1<Enchantment, Unit>((Object)enchants){

                    public final void invoke(Enchantment p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Map)this.receiver).remove(p0);
                    }
                }, arg_0));
            }
        }
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)enchantedBook);
        EnchantmentHelper.m_44865_((Map)MapsKt.emptyMap(), (ItemStack)selectedItem);
        turtleInventory.m_6836_($realSlot, enchantedBook);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/EnchantingAutomataCorePeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "MAX_ENCHANTMENT_LEVEL", "", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @Override
        @NotNull
        public ResourceLocation getUpgradeID() {
            return PeripheralConfiguration.DefaultImpls.getUpgradeID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

