/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.forged;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.Util;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.turtlematic.api.IAutomataCoreTier;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.PowerOperation;
import site.siredvin.turtlematic.computercraft.operations.PowerOperationContext;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.operations.SphereOperation;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.peripheral.forged.ExperienceAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.plugins.AutomataInteractionPlugin;
import site.siredvin.turtlematic.computercraft.plugins.AutomataLookPlugin;
import site.siredvin.turtlematic.util.TurtleDispenseBehavior;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralFunction;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOperation;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoon;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.api.InteractionMode;
import site.siredvin.tweakium.modules.peripheral.boon.ExperienceBoon;
import site.siredvin.tweakium.modules.peripheral.boon.PeripheralOwnerBoonKey;
import site.siredvin.tweakium.modules.peripheral.boon.ScanningBoon;
import site.siredvin.tweakium.modules.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.representation.EnrichersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral;", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/ExperienceAutomataCorePeripheral;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "tier", "Lsite/siredvin/turtlematic/api/IAutomataCoreTier;", "<init>", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/turtlematic/api/IAutomataCoreTier;)V", "isEnabled", "", "()Z", "dispenseBehavior", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$TurtlePotionDispenseBehavior;", "getDispenseBehavior", "()Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$TurtlePotionDispenseBehavior;", "dispenseBehavior$delegate", "Lkotlin/Lazy;", "possibleOperations", "", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOperation;", "brew", "Ldan200/computercraft/api/lua/MethodResult;", "throwPotion", "power", "", "angle", "Companion", "TurtlePotionDispenseBehavior", "turtlematic-forge-1.20.1"})
public final class BrewingAutomataCorePeripheral
extends ExperienceAutomataCorePeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy dispenseBehavior$delegate;
    @NotNull
    private static final String type = "brewingAutomata";
    @NotNull
    private static final Predicate<Entity> suitableEntity = BrewingAutomataCorePeripheral::suitableEntity$lambda$5;

    public BrewingAutomataCorePeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side, @NotNull IAutomataCoreTier tier) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        super(type, turtle, side, tier);
        this.addPlugin(new AutomataLookPlugin(this, CollectionsKt.listOf((Object)EnrichersKt.getEffectsData()), null, null, null, 28, null));
        BiConsumer[] biConsumerArray = ArraysKt.toSet((Object[])InteractionMode.values());
        Predicate<Entity> predicate = suitableEntity;
        this.addPlugin(new AutomataInteractionPlugin(this, predicate, (Set<? extends InteractionMode>)biConsumerArray));
        biConsumerArray = new BiConsumer[]{BrewingAutomataCorePeripheral::_init_$lambda$1};
        ((TurtlePeripheralOwner)this.getPeripheralOwner()).attachBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getSCANNING(), (IPeripheralOwnerBoon)new ScanningBoon(this.getPeripheralOwner(), tier.getInteractionRadius()).attachItemScan((IPeripheralOperation)SphereOperation.SCAN_ITEMS, new BiConsumer[0]).attachLivingEntityScan((IPeripheralOperation)SphereOperation.SCAN_ENTITIES, BrewingAutomataCorePeripheral::_init_$lambda$0, biConsumerArray));
        this.dispenseBehavior$delegate = LazyKt.lazy(() -> BrewingAutomataCorePeripheral.dispenseBehavior_delegate$lambda$2(this));
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableBrewingAutomataCore();
    }

    private final TurtlePotionDispenseBehavior getDispenseBehavior() {
        Lazy lazy = this.dispenseBehavior$delegate;
        return (TurtlePotionDispenseBehavior)lazy.getValue();
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> possibleOperations() {
        List<IPeripheralOperation<?>> operations = super.possibleOperations();
        operations.add(SingleOperation.BREW);
        operations.add(PowerOperation.THROW_POTION);
        return operations;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult brew() throws LuaException {
        return this.withOperation(SingleOperation.BREW, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> BrewingAutomataCorePeripheral.brew$lambda$3(this, arg_0)));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult throwPotion(double power, double angle) throws LuaException {
        if (power <= 0.0) {
            throw new LuaException("Power cannot be 0");
        }
        double limitedPower = RangesKt.coerceAtLeast((double)power, (double)TurtlematicConfig.INSTANCE.getBrewingPowerLimit());
        return BaseAutomataCorePeripheral.withOperation$default(this, PowerOperation.THROW_POTION, new PowerOperationContext(limitedPower), arg_0 -> BrewingAutomataCorePeripheral.throwPotion$lambda$4(this, limitedPower, angle, arg_0), null, 8, null);
    }

    private static final boolean _init_$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return suitableEntity.test((Entity)it);
    }

    private static final void _init_$lambda$1(LivingEntity it1, Map it2) {
        Intrinsics.checkNotNullParameter((Object)it1, (String)"it1");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it2");
        EnrichersKt.getEffectsData().accept(it1, it2);
    }

    private static final TurtlePotionDispenseBehavior dispenseBehavior_delegate$lambda$2(BrewingAutomataCorePeripheral this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new TurtlePotionDispenseBehavior(this$0.getPeripheralOwner());
    }

    private static final MethodResult brew$lambda$3(BrewingAutomataCorePeripheral this$0, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack component = itemStack;
        if (!PotionBrewing.m_43506_((ItemStack)component)) {
            Object[] objectArray = new Object[]{null, "Selected component is not an ingredient for brewing!"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        boolean usedForBrewing = false;
        int n = turtleInventory.m_6643_();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack slotStack;
            if (slot == selectedSlot) continue;
            Intrinsics.checkNotNullExpressionValue((Object)turtleInventory.m_8020_(slot), (String)"getItem(...)");
            if (slotStack.m_41619_() || !PotionBrewing.m_43508_((ItemStack)slotStack, (ItemStack)component)) continue;
            turtleInventory.m_6836_(slot, PotionBrewing.m_43529_((ItemStack)component, (ItemStack)slotStack));
            usedForBrewing = true;
            ExperienceBoon experienceBoon = (ExperienceBoon)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getBoon((IPeripheralOwnerBoonKey)PeripheralOwnerBoonKey.Companion.getEXPERIENCE());
            if (experienceBoon == null) continue;
            experienceBoon.adjustStoredXP(TurtlematicConfig.INSTANCE.getBrewingXPReward());
        }
        if (usedForBrewing) {
            if (component.m_41613_() == 1) {
                turtleInventory.m_6836_(selectedSlot, ItemStack.f_41583_);
            } else {
                component.m_41774_(1);
            }
        }
        MethodResult methodResult = MethodResult.of((Object)usedForBrewing);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final MethodResult throwPotion$lambda$4(BrewingAutomataCorePeripheral this$0, double $limitedPower, double $angle, PowerOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        Container turtleInventory = container;
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack selectedStack = itemStack;
        Item item = selectedStack.m_41720_();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        Item selectedItem = item;
        if (selectedItem != Items.f_42736_ && selectedItem != Items.f_42739_) {
            Object[] objectArray = new Object[]{null, "Selected item should be splash or lingering potion"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)selectedStack);
        Intrinsics.checkNotNullExpressionValue((Object)potion, (String)"getPotion(...)");
        Potion potion2 = potion;
        if (potion2 == Potions.f_43598_) {
            Object[] objectArray = new Object[]{null, "Selected item is not potion"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
            return methodResult;
        }
        TurtlePotionDispenseBehavior turtlePotionDispenseBehavior = this$0.getDispenseBehavior();
        Level level = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        turtleInventory.m_6836_(selectedSlot, turtlePotionDispenseBehavior.dispense((BlockSource)new BlockSourceImpl((ServerLevel)level, ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos()), selectedStack, $limitedPower, $angle));
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    private static final boolean suitableEntity$lambda$5(Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity instanceof ZombieVillager;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "suitableEntity", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @Override
        @NotNull
        public ResourceLocation getUpgradeID() {
            return PeripheralConfiguration.DefaultImpls.getUpgradeID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$TurtlePotionDispenseBehavior;", "Lsite/siredvin/turtlematic/util/TurtleDispenseBehavior;", "owner", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "getProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "level", "Lnet/minecraft/world/level/Level;", "targetPosition", "Lnet/minecraft/core/Position;", "stack", "Lnet/minecraft/world/item/ItemStack;", "turtlematic-forge-1.20.1"})
    public static final class TurtlePotionDispenseBehavior
    extends TurtleDispenseBehavior {
        public TurtlePotionDispenseBehavior(@NotNull IPeripheralOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner);
        }

        @Override
        @NotNull
        public Projectile getProjectile(@NotNull Level level, @NotNull Position targetPosition, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            stack.m_41774_(1);
            Object object = Util.m_137469_((Object)new ThrownPotion(level, targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_()), arg_0 -> TurtlePotionDispenseBehavior.getProjectile$lambda$0(stack, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"make(...)");
            return (Projectile)object;
        }

        private static final void getProjectile$lambda$0(ItemStack $stack, ThrownPotion thrownPotion) {
            Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
            thrownPotion.m_37446_($stack);
        }
    }
}

