/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.gunblades.ammo;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import yourdailymodder.gunblades.setup.Registrations;

public class GunbladeAmmo
extends Projectile {
    public int ammoType;

    public GunbladeAmmo(EntityType<? extends GunbladeAmmo> type, Level level) {
        super(type, level);
    }

    public GunbladeAmmo(Level level, Player entity, int ammoType) {
        this((EntityType<? extends GunbladeAmmo>)((EntityType)Registrations.GUNBLADE_AMMO.get()), level);
        this.ammoType = ammoType;
        this.setOwner((Entity)entity);
        this.setPos(entity.getX() - (double)(entity.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(entity.yBodyRot * ((float)Math.PI / 180))), entity.getEyeY() - (double)0.1f, entity.getZ() + (double)(entity.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(entity.yBodyRot * ((float)Math.PI / 180))));
    }

    public GunbladeAmmo(Level p_36861_, LivingEntity entity, ItemStack p_310691_, @Nullable ItemStack p_344310_, int ammoType2) {
        super((EntityType)Registrations.GUNBLADE_AMMO.get(), p_36861_);
        this.ammoType = ammoType2;
        this.setOwner((Entity)entity);
        this.setPos(entity.getX() - (double)(entity.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(entity.yBodyRot * ((float)Math.PI / 180))), entity.getEyeY() - (double)0.1f, entity.getZ() + (double)(entity.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(entity.yBodyRot * ((float)Math.PI / 180))));
    }

    public GunbladeAmmo(Level p_330586_, double x, double y, double z, ItemStack copyWithCount, int ammoType2) {
        super((EntityType)Registrations.GUNBLADE_AMMO.get(), p_330586_);
        this.ammoType = ammoType2;
        this.setOwner(null);
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard();
        } else if (this.isInWaterOrSwimmable()) {
            this.discard();
        } else {
            this.setDeltaMovement(vec3.scale((double)0.99f));
            if (!this.isNoGravity()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
            }
            this.setPos(d0, d1, d2);
        }
    }

    protected void onHitEntity(EntityHitResult p_37241_) {
        super.onHitEntity(p_37241_);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            p_37241_.getEntity().hurt(this.damageSources().generic(), 5.0f);
            if (p_37241_.getEntity() instanceof LivingEntity) {
                if (this.ammoType == 1) {
                    p_37241_.getEntity().hurt(this.damageSources().onFire(), 1.0f);
                    p_37241_.getEntity().setRemainingFireTicks(100);
                } else if (this.ammoType == 2) {
                    if (p_37241_.getEntity().level() instanceof ServerLevel) {
                        BlockPos blockpos = p_37241_.getEntity().blockPosition();
                        if (p_37241_.getEntity().level().canSeeSky(blockpos)) {
                            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(p_37241_.getEntity().level(), EntitySpawnReason.TRIGGERED);
                            lightningbolt.snapTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
                            lightningbolt.setCause(p_37241_.getEntity() instanceof ServerPlayer ? (ServerPlayer)p_37241_.getEntity() : null);
                            p_37241_.getEntity().level().addFreshEntity((Entity)lightningbolt);
                            p_37241_.getEntity().playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 5.0f, 1.0f);
                        }
                    }
                    ((LivingEntity)p_37241_.getEntity()).addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 3), (Entity)this);
                } else if (this.ammoType == 3) {
                    ((LivingEntity)p_37241_.getEntity()).addEffect(new MobEffectInstance(MobEffects.POISON, 200, 3), p_37241_.getEntity());
                } else if (this.ammoType == 4) {
                    p_37241_.getEntity().hurt(this.damageSources().freeze(), 1.0f);
                    p_37241_.getEntity().setTicksFrozen(400);
                } else if (this.ammoType == 5) {
                    float f = 4.0f;
                    this.level().explode((Entity)this, ((LivingEntity)p_37241_.getEntity()).getX(), ((LivingEntity)p_37241_.getEntity()).getY(), ((LivingEntity)p_37241_.getEntity()).getZ(), f, Level.ExplosionInteraction.MOB);
                    if (this.level().isClientSide) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, ((LivingEntity)p_37241_.getEntity()).getX(), ((LivingEntity)p_37241_.getEntity()).getY() + 0.5, ((LivingEntity)p_37241_.getEntity()).getZ(), 0.0, 0.0, 0.0);
                    }
                    this.level().playSound((Entity)((Player)null), ((LivingEntity)p_37241_.getEntity()).getX(), ((LivingEntity)p_37241_.getEntity()).getY(), ((LivingEntity)p_37241_.getEntity()).getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 1.0f, 1.0f / (((LivingEntity)p_37241_.getEntity()).getRandom().nextFloat() * 0.4f + 1.2f) + 2.5f);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult p_37241_) {
        super.onHitBlock(p_37241_);
        if (!this.level().isClientSide) {
            this.discard();
            if (this.ammoType == 1) {
                if (!this.level().isClientSide) {
                    BlockPos blockpos = p_37241_.getBlockPos().relative(p_37241_.getDirection());
                    if (this.level().isEmptyBlock(blockpos)) {
                        this.level().setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockpos));
                    }
                }
            } else if (this.ammoType == 2) {
                if (!this.level().isClientSide) {
                    BlockPos blockpos = p_37241_.getBlockPos().above();
                    if (this.level().canSeeSky(blockpos)) {
                        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level(), EntitySpawnReason.TRIGGERED);
                        lightningbolt.snapTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
                        lightningbolt.setCause(null);
                        this.level().addFreshEntity((Entity)lightningbolt);
                        this.level().playSound((Entity)((Player)null), (double)p_37241_.getBlockPos().getX(), (double)p_37241_.getBlockPos().getY(), (double)p_37241_.getBlockPos().getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 1.0f, 6.2f);
                    }
                }
            } else if (this.ammoType == 5) {
                float f = 4.0f;
                this.level().explode((Entity)this, (double)p_37241_.getBlockPos().getX(), (double)p_37241_.getBlockPos().getY(), (double)p_37241_.getBlockPos().getZ(), f, Level.ExplosionInteraction.MOB);
                if (this.level().isClientSide) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p_37241_.getBlockPos().getX(), (double)((float)p_37241_.getBlockPos().getY() + 0.5f), (double)p_37241_.getBlockPos().getZ(), 0.0, 0.0, 0.0);
                }
                this.level().playSound((Entity)((Player)null), (double)p_37241_.getBlockPos().getX(), (double)p_37241_.getBlockPos().getY(), (double)p_37241_.getBlockPos().getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 1.0f, 6.2f);
            }
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_150162_) {
        super.recreateFromPacket(p_150162_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_333664_) {
    }
}

