/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.gunblades.items;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import yourdailymodder.gunblades.ammo.GunbladeAmmo;
import yourdailymodder.gunblades.items.AmmoItem;
import yourdailymodder.gunblades.setup.Registrations;

public class GunbladeItem
extends Item {
    public static final Predicate<ItemStack> AMMO = p_43015_ -> p_43015_.is((Item)Registrations.AMMO.get());
    public static final Predicate<ItemStack> AMMO_2 = AMMO.or(p_43015_ -> p_43015_.is((Item)Registrations.AMMO2.get()));
    public static final Predicate<ItemStack> AMMO_3 = AMMO_2.or(p_43015_ -> p_43015_.is((Item)Registrations.AMMO3.get()));
    public static final Predicate<ItemStack> AMMO_4 = AMMO_3.or(p_43015_ -> p_43015_.is((Item)Registrations.AMMO4.get()));
    public static final Predicate<ItemStack> AMMO_5 = AMMO_4.or(p_43015_ -> p_43015_.is((Item)Registrations.AMMO5.get()));
    public static final Predicate<ItemStack> AMMO_ONLY = AMMO_5.or(p_43015_ -> p_43015_.is((Item)Registrations.AMMO6.get()));
    public Random random = new Random();
    private int id;
    public static final ToolMaterial EMERALD = new ToolMaterial(BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1000, 7.0f, 3.0f, 12, Registrations.EMERALD_TOOL_MATERIALS);

    public GunbladeItem(int id, ToolMaterial p_43269_, float p_43270_, float p_43271_, Item.Properties p_43272_) {
        super(p_43272_.sword(p_43269_, p_43270_, p_43271_));
        this.id = id;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (Objects.equal((Object)toolAction, (Object)ToolActions.SWORD_SWEEP) || Objects.equal((Object)toolAction, (Object)ToolActions.SWORD_DIG)) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> p_392123_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_333372_, p_396484_, p_392123_, p_41424_);
        p_392123_.accept((Component)Component.translatable((String)("tooltip.gunblades." + this.id)));
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_40678_) {
        return ItemUseAnimation.SPYGLASS;
    }

    public int getUseDuration(ItemStack p_40680_) {
        return 1000;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_342054_) {
        return 1000;
    }

    public int getDefaultProjectileRange() {
        return 20;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return AMMO_ONLY;
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public static ItemStack getHeldProjectile(LivingEntity p_43011_, Predicate<ItemStack> p_43012_) {
        if (p_43012_.test(p_43011_.getItemInHand(InteractionHand.OFF_HAND))) {
            return p_43011_.getItemInHand(InteractionHand.OFF_HAND);
        }
        return p_43012_.test(p_43011_.getItemInHand(InteractionHand.MAIN_HAND)) ? p_43011_.getItemInHand(InteractionHand.MAIN_HAND) : ItemStack.EMPTY;
    }

    protected int getDurabilityUse(ItemStack p_330687_) {
        return 1;
    }

    public GunbladeAmmo customAmmo(GunbladeAmmo ammo) {
        return ammo;
    }

    public ItemStack getProjectile(ItemStack p_36349_, Player player) {
        if (!(p_36349_.getItem() instanceof GunbladeItem)) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> predicate = this.getAllSupportedProjectiles();
        ItemStack itemstack = GunbladeItem.getHeldProjectile((LivingEntity)player, AMMO_ONLY);
        if (!itemstack.isEmpty()) {
            return itemstack;
        }
        predicate = this.getAllSupportedProjectiles();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = player.getInventory().getItem(i);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return player.getAbilities().instabuild ? new ItemStack((ItemLike)Registrations.AMMO.get()) : ItemStack.EMPTY;
    }

    protected void shoot(ServerLevel p_344476_, LivingEntity p_332682_, InteractionHand p_333462_, ItemStack p_333670_, List<ItemStack> p_328443_, float p_330956_, float p_333326_, boolean p_332457_, @Nullable LivingEntity p_328954_) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)p_344476_, (ItemStack)p_333670_, (Entity)p_332682_, (float)0.0f);
        float f1 = p_328443_.size() == 1 ? 0.0f : 2.0f * f / (float)(p_328443_.size() - 1);
        float f2 = (float)((p_328443_.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < p_328443_.size(); ++i) {
            ItemStack itemstack = p_328443_.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            int j = i;
            Projectile.spawnProjectile((Projectile)this.createProjectile((Level)p_344476_, p_332682_, p_333670_, itemstack, p_332457_), (ServerLevel)p_344476_, (ItemStack)itemstack, p_359794_ -> this.shootProjectile(p_332682_, (Projectile)p_359794_, j, p_330956_, p_333326_, f4, p_328954_));
            p_333670_.hurtAndBreak(this.getDurabilityUse(itemstack), p_332682_, LivingEntity.getSlotForHand((InteractionHand)p_333462_));
            if (p_333670_.isEmpty()) break;
        }
    }

    protected Projectile createProjectile(Level p_333069_, LivingEntity p_334736_, ItemStack p_333680_, ItemStack p_329118_, boolean p_336242_) {
        AmmoItem arrowitem1;
        Item item = p_329118_.getItem();
        AmmoItem arrowitem = item instanceof AmmoItem ? (arrowitem1 = (AmmoItem)item) : (AmmoItem)((Object)Registrations.AMMO.get());
        GunbladeAmmo abstractarrow = arrowitem.createAmmo(p_333069_, p_329118_, p_334736_, p_333680_);
        abstractarrow = this.customAmmo(abstractarrow);
        return abstractarrow;
    }

    protected void shootProjectile(LivingEntity p_329327_, Projectile p_335269_, int p_331005_, float p_332731_, float p_332848_, float p_332058_, @Nullable LivingEntity p_335061_) {
        p_335269_.shootFromRotation((Entity)p_329327_, p_329327_.getXRot(), p_329327_.getYRot() + p_332058_, 0.0f, p_332731_, p_332848_);
    }

    protected static List<ItemStack> draw(ItemStack p_329054_, ItemStack p_328618_, LivingEntity p_335616_) {
        AmmoItem ammo;
        int n;
        if (p_328618_.isEmpty()) {
            return List.of();
        }
        Level level = p_335616_.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            n = EnchantmentHelper.processProjectileCount((ServerLevel)serverlevel, (ItemStack)p_329054_, (Entity)p_335616_, (int)1);
        } else {
            n = 1;
        }
        int i = n;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(i);
        ItemStack itemstack1 = p_328618_.copy();
        Item item = p_328618_.getItem();
        boolean infinite = item instanceof AmmoItem && (ammo = (AmmoItem)item).isInfinite(p_328618_, p_329054_, p_335616_);
        for (int j = 0; j < i; ++j) {
            ItemStack itemstack = GunbladeItem.useAmmo(p_329054_, j == 0 ? p_328618_ : itemstack1, p_335616_, j > 0 || infinite);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
        }
        return list;
    }

    protected static ItemStack useAmmo(ItemStack p_335938_, ItemStack p_332014_, LivingEntity p_332327_, boolean p_327685_) {
        int i;
        Level level;
        if (!p_327685_ && !p_332327_.hasInfiniteMaterials() && (level = p_332327_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            v0 = EnchantmentHelper.processAmmoUse((ServerLevel)serverlevel, (ItemStack)p_335938_, (ItemStack)p_332014_, (int)1);
        } else {
            v0 = i = 0;
        }
        if (i > p_332014_.getCount()) {
            return ItemStack.EMPTY;
        }
        if (i == 0) {
            ItemStack itemstack1 = p_332014_.copyWithCount(1);
            itemstack1.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
            return itemstack1;
        }
        ItemStack itemstack = p_332014_.split(i);
        if (p_332014_.isEmpty() && p_332327_ instanceof Player) {
            Player player = (Player)p_332327_;
            player.getInventory().removeItem(p_332014_);
        }
        return itemstack;
    }

    public boolean releaseUsing(ItemStack p_40667_, Level p_40668_, LivingEntity p_40669_, int p_40670_) {
        if (!(p_40669_ instanceof Player)) {
            return false;
        }
        Player player = (Player)p_40669_;
        ItemStack itemstack = this.getProjectile(p_40667_, player);
        if (itemstack.isEmpty()) {
            return false;
        }
        int i = this.getUseDuration(p_40667_, p_40669_) - p_40670_;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)p_40667_, (Level)p_40668_, (Player)player, (int)i, (boolean)true)) < 0) {
            return false;
        }
        float f = 5.0f;
        List<ItemStack> list = GunbladeItem.draw(p_40667_, itemstack, (LivingEntity)player);
        if (p_40668_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_40668_;
            if (!list.isEmpty()) {
                this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), p_40667_, list, f * 3.0f, 1.0f, f == 1.0f, null);
            }
        }
        p_40668_.playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 1.0f, 1.0f / (p_40668_.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return true;
    }

    public InteractionResult use(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        boolean flag;
        ItemStack itemstack = p_40673_.getItemInHand(p_40674_);
        boolean bl = flag = !this.getProjectile(itemstack, p_40673_).isEmpty();
        if (!p_40673_.hasInfiniteMaterials() && !flag) {
            return InteractionResult.FAIL;
        }
        p_40673_.startUsingItem(p_40674_);
        return InteractionResult.CONSUME;
    }
}

