/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.gunblades.setup;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import yourdailymodder.gunblades.ammo.GunbladeAmmo;
import yourdailymodder.gunblades.items.AmmoItem;
import yourdailymodder.gunblades.items.GunbladeItem;

public class Registrations {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"gunblades");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"gunblades");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"gunblades");
    public static final TagKey<Item> EMERALD_TOOL_MATERIALS = Registrations.bind("emerald_tool_materials");
    public static final RegistryObject<CreativeModeTab> TAB = TABS.register("gunblades_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.gunblades_tab")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> ((GunbladeItem)((Object)((Object)((Object)GUNBLADE.get())))).getDefaultInstance()).displayItems((parameters, output) -> ITEMS.getEntries().forEach(s -> output.accept(new ItemStack((ItemLike)s.get())))).build());
    public static final RegistryObject<GunbladeItem> GUNBLADE = ITEMS.register("gunblade", () -> new GunbladeItem(1, ToolMaterial.IRON, 3.0f, -2.4f, new Item.Properties().setId(Registrations.itemid("gunblade")).component(DataComponents.WEAPON, (Object)new Weapon(1))));
    public static final RegistryObject<GunbladeItem> EMERALD_GUNBLADE = ITEMS.register("emerald_gunblade", () -> new GunbladeItem(1, GunbladeItem.EMERALD, 3.0f, -2.4f, new Item.Properties().setId(Registrations.itemid("emerald_gunblade"))));
    public static final RegistryObject<GunbladeItem> DIAMOND_GUNBLADE = ITEMS.register("diamond_gunblade", () -> new GunbladeItem(1, ToolMaterial.DIAMOND, 3.0f, -2.4f, new Item.Properties().setId(Registrations.itemid("diamond_gunblade"))));
    public static final RegistryObject<GunbladeItem> NETHERITE_GUNBLADE = ITEMS.register("netherite_gunblade", () -> new GunbladeItem(1, ToolMaterial.NETHERITE, 3.0f, -2.4f, new Item.Properties().setId(Registrations.itemid("netherite_gunblade"))));
    public static final RegistryObject<AmmoItem> AMMO = ITEMS.register("ammo", () -> new AmmoItem(0, new Item.Properties().stacksTo(64).setId(Registrations.itemid("ammo"))));
    public static final RegistryObject<AmmoItem> AMMO2 = ITEMS.register("fire_ammo", () -> new AmmoItem(1, new Item.Properties().stacksTo(64).setId(Registrations.itemid("fire_ammo"))));
    public static final RegistryObject<AmmoItem> AMMO3 = ITEMS.register("thunder_ammo", () -> new AmmoItem(2, new Item.Properties().stacksTo(64).setId(Registrations.itemid("thunder_ammo"))));
    public static final RegistryObject<AmmoItem> AMMO4 = ITEMS.register("poison_ammo", () -> new AmmoItem(3, new Item.Properties().stacksTo(64).setId(Registrations.itemid("poison_ammo"))));
    public static final RegistryObject<AmmoItem> AMMO5 = ITEMS.register("frost_ammo", () -> new AmmoItem(4, new Item.Properties().stacksTo(64).setId(Registrations.itemid("frost_ammo"))));
    public static final RegistryObject<AmmoItem> AMMO6 = ITEMS.register("explosion_ammo", () -> new AmmoItem(5, new Item.Properties().stacksTo(64).setId(Registrations.itemid("explosion_ammo"))));
    public static final RegistryObject<EntityType<GunbladeAmmo>> GUNBLADE_AMMO = ENTITIES.register("gunblade_ammo", () -> EntityType.Builder.of(GunbladeAmmo::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setShouldReceiveVelocityUpdates(false).clientTrackingRange(4).updateInterval(10).build(Registrations.mobid("gunblade_ammo")));

    public static void init(FMLJavaModLoadingContext c) {
        ITEMS.register(c.getModEventBus());
        ENTITIES.register(c.getModEventBus());
        TABS.register(c.getModEventBus());
    }

    @NotNull
    private static TagKey<Item> bind(@NotNull String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gunblades", (String)name));
    }

    public static ResourceKey<EntityType<?>> mobid(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gunblades", (String)name));
    }

    public static ResourceKey<Item> itemid(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gunblades", (String)name));
    }
}

