/*
 * Decompiled with CFR 0.152.
 */
package snownee.minieffects.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.minieffects.IAreasGetter;
import snownee.minieffects.MiniEffects;
import snownee.minieffects.MiniEffectsConfig;
import snownee.minieffects.mixin.LivingEntityAccess;

@Mixin(value={EffectRenderingInventoryScreen.class})
public abstract class DisplayEffectsScreenMixin<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IAreasGetter {
    private boolean expand;
    private int effects;
    private Rect2i area;
    private ItemStack iconItem = new ItemStack((ItemLike)Items.f_42589_);

    public DisplayEffectsScreenMixin(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")}, cancellable=true)
    private void minieffects$renderEffects(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        boolean expand;
        this.minieffects$updateArea();
        if (this.area == null) {
            ci.cancel();
            return;
        }
        int effects = 0;
        int bad = 0;
        LocalPlayer player = this.f_96541_.f_91074_;
        for (MobEffectInstance effectInstance : player.m_21220_()) {
            ++effects;
            if (effectInstance.m_19544_().m_19486_()) continue;
            ++bad;
        }
        this.effects = effects;
        int x = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_());
        int y = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
        boolean bl = expand = MiniEffectsConfig.requiresHoldingTab || this.area.m_110087_(x, y);
        if (expand != this.expand) {
            this.expand = expand;
            this.minieffects$updateArea();
        }
        if (effects > 0 && !expand) {
            String s;
            x = this.area.m_110085_();
            y = this.area.m_110086_();
            guiGraphics.m_280398_(AbstractContainerScreen.f_97725_, x, y, 0, 141.0f, 166.0f, 24, 24, 256, 256);
            PoseStack poseStack = guiGraphics.m_280168_();
            if (!MiniEffectsConfig.potionItemIcon) {
                List effectsToShow = player.m_21220_().stream().skip(Math.max(0, effects - 4)).toList();
                MobEffectTextureManager mobEffectTextures = this.f_96541_.m_91306_();
                if (effectsToShow.size() == 1) {
                    guiGraphics.m_280159_(x + 4, y + 4, 0, 16, 16, mobEffectTextures.m_118732_(((MobEffectInstance)effectsToShow.get(0)).m_19544_()));
                } else if (effectsToShow.size() == 2) {
                    guiGraphics.m_280159_(x + 3, y + 4, 0, 10, 10, mobEffectTextures.m_118732_(((MobEffectInstance)effectsToShow.get(0)).m_19544_()));
                    guiGraphics.m_280159_(x + 3 + 8, y + 4 + 8, 0, 10, 10, mobEffectTextures.m_118732_(((MobEffectInstance)effectsToShow.get(1)).m_19544_()));
                } else if (effectsToShow.size() > 2) {
                    MobEffectInstance effectInstance;
                    int i1;
                    int effectsPerLine = Mth.m_14167_((float)((float)effectsToShow.size() / 2.0f));
                    int effectWidth = 16 / effectsPerLine;
                    for (i1 = 0; i1 < effectsPerLine; ++i1) {
                        effectInstance = (MobEffectInstance)effectsToShow.get(i1);
                        guiGraphics.m_280159_(x + 3 + effectWidth * i1, y + 3, 0, 8, 8, mobEffectTextures.m_118732_(effectInstance.m_19544_()));
                    }
                    for (i1 = 0; i1 < effectsToShow.size() - effectsPerLine; ++i1) {
                        effectInstance = (MobEffectInstance)effectsToShow.get(i1 + effectsPerLine);
                        guiGraphics.m_280159_(x + 3 + effectWidth * i1, y + 3 + 9, 0, 8, 8, mobEffectTextures.m_118732_(effectInstance.m_19544_()));
                    }
                }
            } else {
                int color = (Integer)player.m_20088_().m_135370_(LivingEntityAccess.getParameter());
                this.iconItem.m_41784_().m_128405_("CustomPotionColor", color);
                guiGraphics.m_280203_(this.iconItem, x + 3, y + 4);
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 200.0f);
            int yOffset = 0;
            if (effects - bad > 0) {
                yOffset = -10;
                s = Integer.toString(effects - bad);
                guiGraphics.m_280488_(this.f_96541_.f_91062_, s, x + 22 - this.f_96541_.f_91062_.m_92895_(s), y + 14, 0xFFFFFF);
            }
            if (bad > 0) {
                s = Integer.toString(bad);
                guiGraphics.m_280488_(this.f_96541_.f_91062_, s, x + 22 - this.f_96541_.f_91062_.m_92895_(s), y + 14 + yOffset, 0xFF5555);
            }
            poseStack.m_85849_();
            ci.cancel();
        }
    }

    @Unique
    private void minieffects$updateArea() {
        int left;
        boolean fullWidth;
        if (!this.m_194018_()) {
            this.area = null;
            return;
        }
        if (MiniEffects.isLeftSide()) {
            boolean bl = fullWidth = this.f_97735_ > 120;
            left = this.expand ? (fullWidth ? this.f_97735_ - 120 - 4 : this.f_97735_ - 32 - 4) : this.f_97735_ - 20 - 8;
        } else {
            left = this.f_97735_ + this.f_97726_ + 2;
            boolean bl = fullWidth = this.f_96543_ - left >= 120;
        }
        if (this.expand) {
            int height = this.effects > 5 ? 165 : 33 * this.effects;
            this.area = new Rect2i(left, this.f_97736_, fullWidth ? 120 : 32, height);
        } else {
            this.area = new Rect2i(left, this.f_97736_, 20, 20);
        }
    }

    @Override
    public List<Rect2i> getAreas() {
        if (this.area == null || this.effects == 0) {
            return List.of();
        }
        return List.of(this.area);
    }

    @Override
    public boolean isExpanded() {
        return this.expand;
    }

    @Shadow
    public abstract boolean m_194018_();

    @Inject(at={@At(value="HEAD")}, method={"canSeeEffects"}, cancellable=true)
    private void minieffects$canSeeEffects(CallbackInfoReturnable<Boolean> ci) {
        RecipeUpdateListener listener;
        if (MiniEffectsConfig.requiresHoldingTab && Minecraft.m_91087_().f_91066_.f_92092_.getKey().m_84873_() == 258) {
            ci.setReturnValue((Object)false);
            return;
        }
        if (MiniEffectsConfig.requiresHoldingTab && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258)) {
            ci.setReturnValue((Object)false);
            return;
        }
        DisplayEffectsScreenMixin displayEffectsScreenMixin = this;
        if (displayEffectsScreenMixin instanceof RecipeUpdateListener && (listener = (RecipeUpdateListener)displayEffectsScreenMixin).m_5564_().m_100385_()) {
            ci.setReturnValue((Object)false);
            return;
        }
    }
}

