/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.client.screen;

import fox.mods.access_denied.requirements.DimensionRequirement;
import fox.mods.access_denied.requirements.DimensionRequirementChecker;
import fox.mods.access_denied.requirements.DimensionRequirementsLoader;
import fox.mods.access_denied.util.RegistriesUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class DimensionsRequirementsScreen
extends Screen {
    public DimensionsRequirementsScreen() {
        super((Component)Component.literal((String)"Dimensions Requirements"));
    }

    protected void init() {
        super.init();
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        Registry dimensionRegistry = registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE);
        int midX = this.width / 2;
        int startY = this.height / 6;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        int index = 0;
        for (Holder.Reference holder : dimensionRegistry.listElements().toList()) {
            ResourceKey dimKey = holder.key();
            ResourceLocation id = dimKey.location();
            if (!DimensionsRequirementsScreen.isPlayableDimension(id)) continue;
            String dimName = id.toString();
            DimensionRequirement requirement = DimensionRequirementsLoader.getRequirements().get(dimName);
            int buttonX = midX - buttonWidth / 2;
            int buttonY = startY + index * spacing;
            if (buttonY + buttonHeight > this.height - 20) break;
            Button dimButton = Button.builder((Component)Component.literal((String)RegistriesUtils.getDimensionDisplayNameFromRegistryName(dimName)), btn -> {
                if (Minecraft.getInstance().player != null) {
                    Minecraft.getInstance().player.closeContainer();
                    DimensionRequirementChecker.ShowMissingRequirementsMessage((Player)Minecraft.getInstance().player, requirement, dimName);
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"A better requirement showing screen is being worked on and will be provided in the next update. Thanks for being patient!").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), false);
                }
            }).pos(buttonX, buttonY).size(buttonWidth, buttonHeight).build();
            this.addRenderableWidget((GuiEventListener)dimButton);
            ++index;
        }
        if (index == 0 && Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"\u26a0 No dimensions detected!"), false);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        super.onClose();
    }

    private static boolean isPlayableDimension(ResourceLocation id) {
        return !id.getPath().contains("caves") && !id.getPath().contains("debug") && !id.getPath().contains("flat");
    }
}

