/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.event;

import fox.mods.access_denied.AccessDenied;
import fox.mods.access_denied.config.AccessDeniedConfiguration;
import fox.mods.access_denied.requirements.DimensionRequirement;
import fox.mods.access_denied.requirements.DimensionRequirementChecker;
import fox.mods.access_denied.requirements.DimensionRequirementsLoader;
import fox.mods.foxs_core.FoxsCore;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;

@EventBusSubscriber
public class PlayerTravelsToDimension {
    @SubscribeEvent
    private static void playerTravelsToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        DimensionRequirementsLoader.loadRequirements();
        ResourceKey targetDimensionKey = event.getDimension();
        if (targetDimensionKey == null) {
            AccessDenied.LOGGER.warn("Could not determine target dimension for player {}", (Object)player.getName().getString());
            return;
        }
        String dimensionKey = targetDimensionKey.location().toString();
        if (AccessDeniedConfiguration.disabledDimensions.contains(dimensionKey)) {
            FoxsCore.cancelEvent((Event)event);
            if (AccessDeniedConfiguration.pushBackPlayer.booleanValue()) {
                PlayerTravelsToDimension.teleportPlayerOutsidePortal((Player)player);
            }
            DimensionRequirementChecker.showAccessDeniedMessage((Player)player);
            return;
        }
        DimensionRequirement requirement = DimensionRequirementsLoader.getRequirements().get(dimensionKey);
        if (requirement == null) {
            return;
        }
        if (!DimensionRequirementChecker.passedRequirements((Player)player, dimensionKey)) {
            FoxsCore.cancelEvent((Event)event);
            if (AccessDeniedConfiguration.pushBackPlayer.booleanValue()) {
                PlayerTravelsToDimension.teleportPlayerOutsidePortal((Player)player);
            }
            DimensionRequirementChecker.ShowMissingRequirementsMessage((Player)player, requirement, dimensionKey);
            AccessDenied.LOGGER.info("Player {} denied entry to dimension {} due to unmet requirements.", (Object)player.getName().getString(), (Object)dimensionKey);
        }
    }

    private static void teleportPlayerOutsidePortal(Player player) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 teleportVec = player.position().subtract(lookVec.scale(3.0));
        BlockPos teleportPos = new BlockPos((int)teleportVec.x, (int)teleportVec.y, (int)teleportVec.z);
        Level level = player.level();
        BlockState blockState = level.getBlockState(teleportPos);
        if (blockState.isAir()) {
            player.teleportTo(teleportVec.x, teleportVec.y, teleportVec.z);
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos checkPos = teleportPos.offset(x, y, z);
                        BlockState checkState = level.getBlockState(checkPos);
                        if (!checkState.isAir()) continue;
                        player.teleportTo((double)checkPos.getX(), (double)checkPos.getY(), (double)checkPos.getZ());
                        return;
                    }
                }
            }
        }
    }
}

