/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.event;

import fox.mods.access_denied.client.screen.DimensionsRequirementsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="access_denied")
public class ScreenInit {
    private static final ResourceLocation ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"access_denied", (String)"textures/gui/button_icon.png");

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (ScreenInit.isPauseMenu(screen)) {
            int btnWidth = 20;
            int btnHeight = 20;
            int x = screen.width / 2 - 126;
            int y = screen.height / 4 + 98;
            ImageButton btn = new ImageButton(x, y, btnWidth, btnHeight, ICON_TEXTURE, b -> Minecraft.getInstance().setScreen((Screen)new DimensionsRequirementsScreen()));
            event.addListener((GuiEventListener)btn);
        }
    }

    private static boolean isPauseMenu(Screen screen) {
        if (screen == null) {
            return false;
        }
        if (screen instanceof PauseScreen) {
            return true;
        }
        String name = screen.getClass().getSimpleName();
        return "GameMenuScreen".equals(name) || "PauseScreen".equals(name) || "IngameMenuScreen".equals(name);
    }

    public static class ImageButton
    extends Button {
        private final ResourceLocation texture;

        public ImageButton(int x, int y, int width, int height, ResourceLocation texture, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.texture = texture;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.blit(RenderType::guiTextured, this.texture, this.getX() + 2, this.getY() + 2, 0.0f, 0.0f, this.getWidth() - 4, this.getHeight() - 4, this.getWidth() - 4, this.getHeight() - 4, 16, 16, -1);
        }
    }
}

