/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.requirements;

import fox.mods.access_denied.AccessDenied;
import fox.mods.access_denied.config.AccessDeniedConfiguration;
import fox.mods.access_denied.network.AccessDeniedModVariables;
import fox.mods.access_denied.requirements.DimensionRequirement;
import fox.mods.access_denied.requirements.DimensionRequirementsLoader;
import fox.mods.access_denied.util.CuriosUtils;
import fox.mods.access_denied.util.RegistriesUtils;
import java.text.DecimalFormat;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DimensionRequirementChecker {
    public static boolean passedRequirements(Player player, String dimensionKey) {
        boolean requirementsPassed = false;
        DimensionRequirement requirement = DimensionRequirementsLoader.getRequirements().get(dimensionKey);
        if (DimensionRequirementChecker.passedBlocksBrokenRequirement(player, requirement) && DimensionRequirementChecker.passedBlocksPlacedRequirement(player, requirement) && DimensionRequirementChecker.passedXpRequirement(player, requirement) && DimensionRequirementChecker.passedPlayerKillsRequirement(player, requirement) && DimensionRequirementChecker.passedMobKillsRequirement(player, requirement) && DimensionRequirementChecker.passedPlayTimeRequirement(player, requirement) && DimensionRequirementChecker.passedItemsKeyRequirement(player, requirement) && DimensionRequirementChecker.passedEffectsRequirement(player, requirement) && DimensionRequirementChecker.passedHealthRequirement(player, requirement) && DimensionRequirementChecker.passedDeathsRequirement(player, requirement) && DimensionRequirementChecker.passedChanceRequirement(player, requirement) && DimensionRequirementChecker.passedAdvancementsRequirement(player, requirement) && DimensionRequirementChecker.passedJumpsRequirement(player, requirement) && DimensionRequirementChecker.passedTimesFishedRequirement(player, requirement) && DimensionRequirementChecker.passedMobBountiesRequirement(player, requirement) && DimensionRequirementChecker.passedBlockBountiesRequirement(player, requirement) && DimensionRequirementChecker.passedLocationBiomeRequirement(player, requirement) && DimensionRequirementChecker.passedLocationDimensionRequirement(player, requirement)) {
            requirementsPassed = true;
        }
        return requirementsPassed;
    }

    private static boolean passedBlocksBrokenRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int blocksBroken = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksBroken;
        if (blocksBroken >= requirement.blocksBroken()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedBlocksPlacedRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int blocksPlaced = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksPlaced;
        if (blocksPlaced >= requirement.blocksPlaced()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedXpRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        if (player.experienceLevel >= requirement.xpLevel()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedPlayerKillsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int playerKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playerKills;
        if (playerKills >= requirement.playerKills()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedMobKillsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int mobKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).mobKills;
        if (mobKills >= requirement.mobKills()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedPlayTimeRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int playTime = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playTime;
        if (playTime >= requirement.playTime()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedItemsKeyRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || requirement.itemsKey() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int passedItems = 0;
        for (Map.Entry<String, Boolean> entry : requirement.itemsKey().entrySet()) {
            String itemName = entry.getKey();
            boolean shouldConsume = entry.getValue();
            Item itemKey = RegistriesUtils.itemFromRegistryName(itemName);
            boolean found = false;
            for (int slot = 0; slot < player.getInventory().items.size(); ++slot) {
                ItemStack stack = (ItemStack)player.getInventory().items.get(slot);
                if (!stack.is(itemKey) && itemKey != Items.AIR) continue;
                found = true;
                ++passedItems;
                if (!shouldConsume) break;
                stack.shrink(1);
                if (!stack.isEmpty()) break;
                player.getInventory().items.set(slot, (Object)ItemStack.EMPTY);
                break;
            }
            if (found || !AccessDenied.curios || !CuriosUtils.hasItemInSlot(player, itemKey)) continue;
            ++passedItems;
            if (!shouldConsume) continue;
            CuriosUtils.removeItemFromSlot(player, itemKey);
        }
        if (passedItems == requirement.itemsKey().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedEffectsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || requirement.effects() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int effectsPassed = 0;
        for (int i = 0; i < requirement.effects().size(); ++i) {
            Holder.Reference<MobEffect> effect = RegistriesUtils.effectFromRegistryName(requirement.effects().get(i));
            if (!player.hasEffect(effect) && effect != MobEffects.HEAL) continue;
            ++effectsPassed;
        }
        if (effectsPassed == requirement.effects().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedHealthRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        if (player.getHealth() >= requirement.health()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedDeathsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int deaths = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).deaths;
        if (deaths >= requirement.deaths()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedChanceRequirement(Player player, DimensionRequirement requirement) {
        double requirementChance;
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        double chance = Math.random();
        if (chance <= (requirementChance = (double)requirement.chance() / 100.0) || requirement.chance() == 0) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedAdvancementsRequirement(Player player, DimensionRequirement requirement) {
        ServerPlayer serverPlayer;
        boolean requirementPassed = false;
        if (requirement == null || requirement.advancements() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int passedAdvancements = 0;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).level() instanceof ServerLevel) {
            for (int i = 0; i < requirement.advancements().size(); ++i) {
                if (!RegistriesUtils.getAdvancementDisplayName(serverPlayer.getServer(), requirement.advancements().get(i)).equals("") && !serverPlayer.getAdvancements().getOrStartProgress(serverPlayer.server.getAdvancements().get(ResourceLocation.parse((String)requirement.advancements().get(i)))).isDone()) continue;
                ++passedAdvancements;
            }
        }
        if (passedAdvancements == requirement.advancements().size()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedJumpsRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int jumps = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).jumps;
        if (jumps >= requirement.jumps()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedTimesFishedRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        int timesFished = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).timesFished;
        if (timesFished >= requirement.timesFished()) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedMobBountiesRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || requirement.mobBounties() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        Map<String, Integer> requiredBounties = requirement.mobBounties();
        Map<String, Integer> playerBounties = ((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).mobBounties;
        if (playerBounties == null) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : requiredBounties.entrySet()) {
            String key = entry.getKey();
            int requiredValue = entry.getValue();
            int playerValue = playerBounties.getOrDefault(key, 0);
            if (playerValue >= requiredValue) continue;
            return false;
        }
        return true;
    }

    private static boolean passedBlockBountiesRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || requirement.blockBounties() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        Map<String, Integer> requiredBounties = requirement.blockBounties();
        Map<String, Integer> playerBounties = ((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blockBounties;
        if (playerBounties == null) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : requiredBounties.entrySet()) {
            String key = entry.getKey();
            int requiredValue = entry.getValue();
            int playerValue = playerBounties.getOrDefault(key, 0);
            if (playerValue >= requiredValue) continue;
            return false;
        }
        return true;
    }

    private static boolean passedLocationBiomeRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || requirement.locationBiome() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        Holder biomeHolder = player.level().getBiome(player.blockPosition());
        ResourceKey biomeKey = biomeHolder.unwrapKey().orElse(null);
        String registryName = biomeKey.location().toString();
        if (registryName.equals(requirement.locationBiome())) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    private static boolean passedLocationDimensionRequirement(Player player, DimensionRequirement requirement) {
        boolean requirementPassed = false;
        if (requirement == null || requirement.locationDimension() == null) {
            requirementPassed = true;
            return requirementPassed;
        }
        ResourceKey targetDimensionKey = player.level().dimension();
        String dimensionKey = targetDimensionKey.location().toString();
        if (dimensionKey.equals(requirement.locationDimension())) {
            requirementPassed = true;
        }
        return requirementPassed;
    }

    /*
     * WARNING - void declaration
     */
    public static void ShowMissingRequirementsMessage(Player player, DimensionRequirement requirement, String dimensionKey) {
        String msg;
        String raw;
        int missing;
        int playerValue;
        Object sectionToAppend;
        if (requirement == null) {
            return;
        }
        int blocksBroken = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksBroken;
        int blocksPlaced = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blocksPlaced;
        int playerKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playerKills;
        int mobKills = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).mobKills;
        int playTime = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).playTime;
        int deaths = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).deaths;
        int jumps = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).jumps;
        int timesFished = (int)((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).timesFished;
        Map<String, Integer> mobBounties = ((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).mobBounties;
        Map<String, Integer> blockBounties = ((AccessDeniedModVariables.PlayerVariables)player.getData(AccessDeniedModVariables.PLAYER_VARIABLES)).blockBounties;
        boolean showBlocksBrokenRequirement = !DimensionRequirementChecker.passedBlocksBrokenRequirement(player, requirement);
        boolean showBlocksPlacedRequirement = !DimensionRequirementChecker.passedBlocksPlacedRequirement(player, requirement);
        boolean showXpRequirement = !DimensionRequirementChecker.passedXpRequirement(player, requirement);
        boolean showPlayerKillsRequirement = !DimensionRequirementChecker.passedPlayerKillsRequirement(player, requirement);
        boolean showMobKillsRequirement = !DimensionRequirementChecker.passedMobKillsRequirement(player, requirement);
        boolean showPlayTimeRequirement = !DimensionRequirementChecker.passedPlayTimeRequirement(player, requirement);
        boolean showItemKeyRequirement = !DimensionRequirementChecker.passedItemsKeyRequirement(player, requirement);
        boolean showEffectRequirement = !DimensionRequirementChecker.passedEffectsRequirement(player, requirement);
        boolean showHealthRequirement = !DimensionRequirementChecker.passedHealthRequirement(player, requirement);
        boolean showDeathsRequirement = !DimensionRequirementChecker.passedDeathsRequirement(player, requirement);
        boolean showChanceRequirement = !DimensionRequirementChecker.passedChanceRequirement(player, requirement);
        boolean showAdvancementRequirement = !DimensionRequirementChecker.passedAdvancementsRequirement(player, requirement);
        boolean showJumpsRequirement = !DimensionRequirementChecker.passedJumpsRequirement(player, requirement);
        boolean showTimesFishedRequirement = !DimensionRequirementChecker.passedTimesFishedRequirement(player, requirement);
        boolean showMobBountiesRequirement = !DimensionRequirementChecker.passedMobBountiesRequirement(player, requirement);
        boolean showBlockBountiesRequirement = !DimensionRequirementChecker.passedBlockBountiesRequirement(player, requirement);
        boolean showLocationBiomeRequirement = !DimensionRequirementChecker.passedLocationBiomeRequirement(player, requirement);
        boolean showLocationDimensionRequirement = !DimensionRequirementChecker.passedLocationDimensionRequirement(player, requirement);
        StringBuilder message = new StringBuilder(ChatFormatting.RED.toString() + AccessDeniedConfiguration.requirementsMessageBuilder.get(0) + "\n");
        if (showBlocksBrokenRequirement) {
            int missingBlocksToBreak = requirement.blocksBroken() - blocksBroken;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(1).replace("%missingBlocksBroken%", ChatFormatting.YELLOW.toString() + missingBlocksToBreak + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showBlocksPlacedRequirement) {
            int missingBlocksToPlace = requirement.blocksPlaced() - blocksPlaced;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(2).replace("%missingBlocksPlaced%", ChatFormatting.YELLOW.toString() + missingBlocksToPlace + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showXpRequirement) {
            int missingXp = requirement.xpLevel() - player.experienceLevel;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(3).replace("%missingXpLevels%", ChatFormatting.YELLOW.toString() + missingXp + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showPlayerKillsRequirement) {
            int missingPlayerKills = requirement.playerKills() - playerKills;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(4).replace("%missingPlayerKills%", ChatFormatting.YELLOW.toString() + missingPlayerKills + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showMobKillsRequirement) {
            int missingMobKills = requirement.mobKills() - mobKills;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(5).replace("%missingMobKills%", ChatFormatting.YELLOW.toString() + missingMobKills + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showPlayTimeRequirement) {
            int missingPlayTime = requirement.playTime() - playTime;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(6).replace("%missingPlayTime%", ChatFormatting.YELLOW.toString() + missingPlayTime + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showItemKeyRequirement) {
            StringBuilder itemsKeyMessage = new StringBuilder();
            for (Map.Entry entry : requirement.itemsKey().entrySet()) {
                String itemName = (String)entry.getKey();
                Item item = RegistriesUtils.itemFromRegistryName(itemName);
                if (item == Items.AIR || player.getInventory().contains(new ItemStack((ItemLike)item))) continue;
                String missingItem = item.getName().getString();
                if (!itemsKeyMessage.isEmpty()) {
                    itemsKeyMessage.append(ChatFormatting.GOLD).append(", ");
                }
                itemsKeyMessage.append(ChatFormatting.YELLOW).append(missingItem);
            }
            if (!itemsKeyMessage.isEmpty()) {
                sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(7).replace("%missingItems%", String.valueOf(ChatFormatting.YELLOW) + itemsKeyMessage.toString() + String.valueOf(ChatFormatting.GOLD)) + "\n" + String.valueOf(ChatFormatting.RED);
                message.append((String)sectionToAppend);
            }
        }
        if (showEffectRequirement) {
            StringBuilder effectsMessage = new StringBuilder();
            for (int i = 0; i < requirement.effects().size(); ++i) {
                String string = RegistriesUtils.getEffectDisplayName(RegistriesUtils.effectFromRegistryName(requirement.effects().get(i)));
                if (player.hasEffect(RegistriesUtils.effectFromRegistryName(requirement.effects().get(i))) || RegistriesUtils.effectFromRegistryName(requirement.effects().get(i)) == MobEffects.HEAL) continue;
                if (i == requirement.effects().size() - 1) {
                    effectsMessage.append(ChatFormatting.YELLOW.toString() + string);
                    continue;
                }
                effectsMessage.append(ChatFormatting.YELLOW.toString() + string + ", ");
            }
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(8).replace("%missingEffects%", ChatFormatting.YELLOW.toString() + String.valueOf(effectsMessage) + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showHealthRequirement) {
            float missingHealth = (requirement.health() - player.getHealth()) / 2.0f;
            String formattedMissingHealth = new DecimalFormat("##.#").format(missingHealth);
            String string = AccessDeniedConfiguration.requirementsMessageBuilder.get(9).replace("%missingHealth%", ChatFormatting.YELLOW.toString() + formattedMissingHealth + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(string);
        }
        if (showDeathsRequirement) {
            int missingDeaths = requirement.deaths() - deaths;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(10).replace("%missingDeaths%", ChatFormatting.YELLOW.toString() + missingDeaths + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showChanceRequirement) {
            String sectionToAppend3 = AccessDeniedConfiguration.requirementsMessageBuilder.get(11).replace("%chance%", ChatFormatting.YELLOW.toString() + requirement.chance() + "%" + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append(sectionToAppend3);
        }
        if (showAdvancementRequirement) {
            ServerPlayer serverPlayer;
            StringBuilder advancementsMessage = new StringBuilder();
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).level() instanceof ServerLevel) {
                void var34_53;
                boolean bl = false;
                while (var34_53 < requirement.advancements().size()) {
                    String missingAdvancement = "";
                    missingAdvancement = RegistriesUtils.getAdvancementDisplayName(serverPlayer.getServer(), requirement.advancements().get((int)var34_53));
                    if (!RegistriesUtils.getAdvancementDisplayName(serverPlayer.getServer(), requirement.advancements().get((int)var34_53)).equals("") && !serverPlayer.getAdvancements().getOrStartProgress(serverPlayer.server.getAdvancements().get(ResourceLocation.parse((String)requirement.advancements().get((int)var34_53)))).isDone()) {
                        if (var34_53 == requirement.advancements().size() - 1) {
                            advancementsMessage.append(ChatFormatting.YELLOW.toString() + missingAdvancement);
                        } else {
                            advancementsMessage.append(ChatFormatting.YELLOW.toString() + missingAdvancement + ", ");
                        }
                    }
                    ++var34_53;
                }
            }
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(12).replace("%missingAdvancements%", ChatFormatting.YELLOW.toString() + String.valueOf(advancementsMessage) + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showJumpsRequirement) {
            int missingJumps = requirement.jumps() - jumps;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(13).replace("%missingJumps%", ChatFormatting.YELLOW.toString() + missingJumps + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showTimesFishedRequirement) {
            int missingFishingCount = requirement.timesFished() - timesFished;
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(14).replace("%missingFishingCount%", ChatFormatting.YELLOW.toString() + missingFishingCount + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showMobBountiesRequirement) {
            Map<String, Integer> requiredBounties = requirement.mobBounties();
            if (mobBounties == null) {
                mobBounties = Map.of();
            }
            for (Map.Entry<String, Integer> entry : requiredBounties.entrySet()) {
                String mob = entry.getKey();
                String mobDisplayName = RegistriesUtils.getMobNameFromRegistryName(mob);
                int requiredValue = entry.getValue();
                playerValue = mobBounties.getOrDefault(mob, 0);
                if (playerValue >= requiredValue) continue;
                missing = requiredValue - playerValue;
                raw = AccessDeniedConfiguration.requirementsMessageBuilder.get(15);
                msg = raw.replace("%count%", ChatFormatting.GOLD.toString() + String.valueOf(missing) + ChatFormatting.RED.toString()).replace("%mob%", ChatFormatting.YELLOW.toString() + mobDisplayName + ChatFormatting.RED.toString() + "\n");
                message.append(msg);
            }
        }
        if (showBlockBountiesRequirement) {
            Map<String, Integer> requiredBounties = requirement.blockBounties();
            if (blockBounties == null) {
                blockBounties = Map.of();
            }
            for (Map.Entry entry : requiredBounties.entrySet()) {
                String block = (String)entry.getKey();
                String blockDisplayName = RegistriesUtils.getBlockNameFromRegistryName(block);
                int requiredValue = (Integer)entry.getValue();
                playerValue = blockBounties.getOrDefault(block, 0);
                if (playerValue >= requiredValue) continue;
                missing = requiredValue - playerValue;
                raw = AccessDeniedConfiguration.requirementsMessageBuilder.get(16);
                msg = raw.replace("%count%", ChatFormatting.GOLD.toString() + String.valueOf(missing) + ChatFormatting.RED.toString()).replace("%block%", ChatFormatting.YELLOW.toString() + blockDisplayName + ChatFormatting.RED.toString() + "\n");
                message.append(msg);
            }
        }
        if (showLocationBiomeRequirement) {
            String biomeName = RegistriesUtils.getBiomeDisplayNameFromRegistryName(requirement.locationBiome(), player.level());
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(17).replace("%biome%", ChatFormatting.YELLOW.toString() + biomeName + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        if (showLocationDimensionRequirement) {
            String dimensionName = RegistriesUtils.getDimensionDisplayNameFromRegistryName(requirement.locationDimension());
            sectionToAppend = AccessDeniedConfiguration.requirementsMessageBuilder.get(18).replace("%dimension%", ChatFormatting.YELLOW.toString() + dimensionName + ChatFormatting.GOLD.toString()) + "\n" + ChatFormatting.RED.toString();
            message.append((String)sectionToAppend);
        }
        message.append(AccessDeniedConfiguration.requirementsMessageBuilder.get(19).replace("%targetDimension%", ChatFormatting.YELLOW.toString() + RegistriesUtils.getDimensionDisplayNameFromRegistryName(dimensionKey)));
        player.displayClientMessage((Component)Component.literal((String)message.toString()), false);
    }

    public static void showAccessDeniedMessage(Player player) {
        player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + ChatFormatting.BOLD.toString() + AccessDeniedConfiguration.accessDeniedMessage)), true);
    }
}

